/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class ReinitializeVariableValueSelector
extends AbstractValueSelector {
    protected final ValueSelector childValueSelector;
    protected final SelectionFilter reinitializeVariableEntityFilter;
    protected ScoreDirector scoreDirector = null;

    public ReinitializeVariableValueSelector(ValueSelector childValueSelector) {
        this.childValueSelector = childValueSelector;
        this.reinitializeVariableEntityFilter = childValueSelector.getVariableDescriptor().getReinitializeVariableEntityFilter();
        this.solverPhaseLifecycleSupport.addEventListener(childValueSelector);
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        if (!this.reinitializeVariableEntityFilter.accept(this.scoreDirector, entity)) {
            return 0L;
        }
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        if (!this.reinitializeVariableEntityFilter.accept(this.scoreDirector, entity)) {
            return Iterators.emptyIterator();
        }
        return this.childValueSelector.iterator(entity);
    }

    public String toString() {
        return "Reinitialize(" + this.childValueSelector + ")";
    }
}

