/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.tabu;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.TabuSizeStrategy;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;

public abstract class AbstractTabuAcceptor
extends AbstractAcceptor {
    protected TabuSizeStrategy tabuSizeStrategy = null;
    protected TabuSizeStrategy fadingTabuSizeStrategy = null;
    protected boolean aspirationEnabled = true;
    protected boolean assertTabuHashCodeCorrectness = false;
    protected Map<Object, Integer> tabuToStepIndexMap;
    protected List<Object> tabuSequenceList;
    protected int workingTabuSize = -1;
    protected int workingFadingTabuSize = -1;

    public void setTabuSizeStrategy(TabuSizeStrategy tabuSizeStrategy) {
        this.tabuSizeStrategy = tabuSizeStrategy;
    }

    public void setFadingTabuSizeStrategy(TabuSizeStrategy fadingTabuSizeStrategy) {
        this.fadingTabuSizeStrategy = fadingTabuSizeStrategy;
    }

    public void setAspirationEnabled(boolean aspirationEnabled) {
        this.aspirationEnabled = aspirationEnabled;
    }

    public void setAssertTabuHashCodeCorrectness(boolean assertTabuHashCodeCorrectness) {
        this.assertTabuHashCodeCorrectness = assertTabuHashCodeCorrectness;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        LocalSearchStepScope lastCompletedStepScope = phaseScope.getLastCompletedStepScope();
        this.workingTabuSize = this.tabuSizeStrategy == null ? 0 : this.tabuSizeStrategy.determineTabuSize(lastCompletedStepScope);
        this.workingFadingTabuSize = this.fadingTabuSizeStrategy == null ? 0 : this.fadingTabuSizeStrategy.determineTabuSize(lastCompletedStepScope);
        int totalTabuListSize = this.workingTabuSize + this.workingFadingTabuSize;
        this.tabuToStepIndexMap = new HashMap<Object, Integer>(totalTabuListSize);
        this.tabuSequenceList = new LinkedList<Object>();
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.tabuToStepIndexMap = null;
        this.tabuSequenceList = null;
        this.workingTabuSize = -1;
        this.workingFadingTabuSize = -1;
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.workingTabuSize = this.tabuSizeStrategy == null ? 0 : this.tabuSizeStrategy.determineTabuSize(stepScope);
        this.workingFadingTabuSize = this.fadingTabuSizeStrategy == null ? 0 : this.fadingTabuSizeStrategy.determineTabuSize(stepScope);
        this.adjustTabuList(stepScope.getStepIndex(), this.findNewTabu(stepScope));
    }

    protected void adjustTabuList(int tabuStepIndex, Collection<? extends Object> tabus) {
        int totalTabuListSize = this.workingTabuSize + this.workingFadingTabuSize;
        Iterator<Object> it = this.tabuSequenceList.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            Integer oldTabuStepIndexInteger = this.tabuToStepIndexMap.get(object);
            if (oldTabuStepIndexInteger == null) {
                throw new IllegalStateException("HashCode violation: the hashCode of tabu (" + object + ") probably changed since it was inserted in the tabu Map or Set.");
            }
            int oldTabuStepCount = tabuStepIndex - oldTabuStepIndexInteger;
            if (oldTabuStepCount < totalTabuListSize) break;
            it.remove();
            this.tabuToStepIndexMap.remove(object);
        }
        for (Object object : tabus) {
            if (this.tabuToStepIndexMap.containsKey(object)) {
                this.tabuToStepIndexMap.remove(object);
                this.tabuSequenceList.remove(object);
            }
            this.tabuToStepIndexMap.put(object, tabuStepIndex);
            this.tabuSequenceList.add(object);
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        boolean accepted;
        int maximumTabuStepIndex = this.locateMaximumTabStepIndex(moveScope);
        if (maximumTabuStepIndex < 0) {
            return true;
        }
        if (this.aspirationEnabled && moveScope.getScore().compareTo(moveScope.getStepScope().getPhaseScope().getBestScore()) > 0) {
            this.logger.trace("        Proposed move ({}) is tabu, but is accepted anyway due to aspiration.", (Object)moveScope.getMove());
            return true;
        }
        int tabuStepCount = moveScope.getStepScope().getStepIndex() - maximumTabuStepIndex;
        if (tabuStepCount <= this.workingTabuSize) {
            this.logger.trace("        Proposed move ({}) is tabu and is therefore not accepted.", (Object)moveScope.getMove());
            return false;
        }
        double acceptChance = this.calculateFadingTabuAcceptChance(tabuStepCount - this.workingTabuSize);
        boolean bl = accepted = moveScope.getWorkingRandom().nextDouble() < acceptChance;
        if (accepted) {
            this.logger.trace("        Proposed move ({}) is fading tabu with acceptChance ({}) and is accepted.", (Object)moveScope.getMove(), (Object)acceptChance);
        } else {
            this.logger.trace("        Proposed move ({}) is fading tabu with acceptChance ({}) and is not accepted.", (Object)moveScope.getMove(), (Object)acceptChance);
        }
        return accepted;
    }

    private int locateMaximumTabStepIndex(LocalSearchMoveScope moveScope) {
        Collection<? extends Object> checkingTabus = this.findTabu(moveScope);
        int maximumTabuStepIndex = -1;
        for (Object object : checkingTabus) {
            Integer tabuStepIndexInteger = this.tabuToStepIndexMap.get(object);
            if (tabuStepIndexInteger != null) {
                maximumTabuStepIndex = Math.max(tabuStepIndexInteger, maximumTabuStepIndex);
            }
            if (!this.assertTabuHashCodeCorrectness) continue;
            for (Object tabu : this.tabuSequenceList) {
                if (!tabu.equals(object)) continue;
                if (tabu.hashCode() != object.hashCode()) {
                    throw new IllegalStateException("HashCode violation: tabu (" + tabu + ") and checkingTabu (" + object + ") are equal but have a different hashCode.");
                }
                if (tabuStepIndexInteger != null) continue;
                throw new IllegalStateException("HashCode violation: the hashCode of tabu (" + tabu + ") probably changed since it was inserted in the tabu Map or Set.");
            }
        }
        return maximumTabuStepIndex;
    }

    protected double calculateFadingTabuAcceptChance(int fadingTabuStepCount) {
        return (double)(this.workingFadingTabuSize - fadingTabuStepCount) / (double)(this.workingFadingTabuSize + 1);
    }

    protected abstract Collection<? extends Object> findTabu(LocalSearchMoveScope var1);

    protected abstract Collection<? extends Object> findNewTabu(LocalSearchStepScope var1);
}

