/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase.custom;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhase;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhaseCommand;
import org.optaplanner.core.impl.phase.custom.scope.CustomSolverPhaseScope;
import org.optaplanner.core.impl.phase.custom.scope.CustomStepScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultCustomSolverPhase
extends AbstractSolverPhase
implements CustomSolverPhase {
    protected List<CustomSolverPhaseCommand> customSolverPhaseCommandList;
    protected boolean forceUpdateBestSolution;

    public void setCustomSolverPhaseCommandList(List<CustomSolverPhaseCommand> customSolverPhaseCommandList) {
        this.customSolverPhaseCommandList = customSolverPhaseCommandList;
    }

    public void setForceUpdateBestSolution(boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        CustomSolverPhaseScope phaseScope = new CustomSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        CustomStepScope stepScope = new CustomStepScope(phaseScope);
        Iterator<CustomSolverPhaseCommand> commandIterator = this.customSolverPhaseCommandList.iterator();
        while (!this.termination.isPhaseTerminated(phaseScope) && commandIterator.hasNext()) {
            CustomSolverPhaseCommand customSolverPhaseCommand = commandIterator.next();
            this.stepStarted(stepScope);
            this.doStep(stepScope, customSolverPhaseCommand);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            stepScope = new CustomStepScope(phaseScope);
        }
        this.phaseEnded(phaseScope);
    }

    public void phaseStarted(CustomSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
    }

    public void stepStarted(CustomStepScope stepScope) {
        super.stepStarted(stepScope);
    }

    private void doStep(CustomStepScope stepScope, CustomSolverPhaseCommand customSolverPhaseCommand) {
        ScoreDirector scoreDirector = stepScope.getScoreDirector();
        customSolverPhaseCommand.changeWorkingSolution(scoreDirector);
        int uninitializedVariableCount = scoreDirector.getSolutionDescriptor().countUninitializedVariables(stepScope.getWorkingSolution());
        stepScope.setUninitializedVariableCount(uninitializedVariableCount);
        Score score = scoreDirector.calculateScore();
        stepScope.setScore(score);
        this.bestSolutionRecaller.processWorkingSolutionDuringStep(stepScope);
    }

    public void stepEnded(CustomStepScope stepScope) {
        super.stepEnded(stepScope);
        boolean bestScoreImproved = stepScope.getBestScoreImproved();
        if (this.forceUpdateBestSolution && !bestScoreImproved) {
            DefaultSolverScope solverScope = stepScope.getPhaseScope().getSolverScope();
            Solution newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
            this.bestSolutionRecaller.updateBestSolution(solverScope, newBestSolution, stepScope.getUninitializedVariableCount());
        }
        CustomSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpent = phaseScope.calculateSolverTimeMillisSpent();
            this.logger.debug("    Custom step ({}), time spent ({}), score ({}), {} best score ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpent, stepScope.getScore(), bestScoreImproved ? "new" : (this.forceUpdateBestSolution ? "forced" : "   "), phaseScope.getBestScoreWithUninitializedPrefix()});
        }
    }

    public void phaseEnded(CustomSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.logger.info("Custom phase ({}) ended: step total ({}), time spent ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getNextStepIndex(), phaseScope.calculateSolverTimeMillisSpent(), phaseScope.getBestScore()});
    }
}

