/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendable;

import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendable.BendableScoreHolder;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrendLevel;

public class BendableScoreDefinition
extends AbstractScoreDefinition<BendableScore> {
    private final int hardLevelCount;
    private final int softLevelCount;
    private double recursiveTimeGradientWeight = 0.5;

    public BendableScoreDefinition(int hardLevelCount, int softLevelCount) {
        this.hardLevelCount = hardLevelCount;
        this.softLevelCount = softLevelCount;
    }

    public int getHardLevelCount() {
        return this.hardLevelCount;
    }

    public int getSoftLevelCount() {
        return this.softLevelCount;
    }

    public double getRecursiveTimeGradientWeight() {
        return this.recursiveTimeGradientWeight;
    }

    public void setRecursiveTimeGradientWeight(double recursiveTimeGradientWeight) {
        this.recursiveTimeGradientWeight = recursiveTimeGradientWeight;
        if (recursiveTimeGradientWeight < 0.0 || recursiveTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property recursiveTimeGradientWeight (" + recursiveTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    @Override
    public int getLevelCount() {
        return this.hardLevelCount + this.softLevelCount;
    }

    @Override
    public Class<BendableScore> getScoreClass() {
        return BendableScore.class;
    }

    @Override
    public BendableScore parseScore(String scoreString) {
        return BendableScore.parseScore(this.hardLevelCount, this.softLevelCount, scoreString);
    }

    public BendableScore createScore(int ... scores) {
        int levelCount = this.hardLevelCount + this.softLevelCount;
        if (scores.length != levelCount) {
            throw new IllegalArgumentException("The scores (" + Arrays.toString(scores) + ")'s length (" + scores.length + ") is not levelCount (" + levelCount + ").");
        }
        return BendableScore.valueOf(Arrays.copyOfRange(scores, 0, this.hardLevelCount), Arrays.copyOfRange(scores, this.hardLevelCount, levelCount));
    }

    @Override
    public double calculateTimeGradient(BendableScore startScore, BendableScore endScore, BendableScore score) {
        startScore.validateCompatible(score);
        score.validateCompatible(endScore);
        if (score.compareTo(endScore) > 0) {
            return 1.0;
        }
        if (score.compareTo(startScore) < 0) {
            return 0.0;
        }
        double timeGradient = 0.0;
        double remainingTimeGradient = 1.0;
        int levelCount = this.hardLevelCount + this.softLevelCount;
        for (int i = 0; i < levelCount; ++i) {
            int scoreLevel;
            double levelTimeGradientWeight;
            if (i != levelCount - 1) {
                levelTimeGradientWeight = remainingTimeGradient * this.recursiveTimeGradientWeight;
                remainingTimeGradient -= levelTimeGradientWeight;
            } else {
                levelTimeGradientWeight = remainingTimeGradient;
            }
            int startScoreLevel = i < this.hardLevelCount ? startScore.getHardScore(i) : startScore.getSoftScore(i - this.hardLevelCount);
            int endScoreLevel = i < this.hardLevelCount ? endScore.getHardScore(i) : endScore.getSoftScore(i - this.hardLevelCount);
            int n = scoreLevel = i < this.hardLevelCount ? score.getHardScore(i) : score.getSoftScore(i - this.hardLevelCount);
            if (scoreLevel >= endScoreLevel) {
                timeGradient += levelTimeGradientWeight;
                continue;
            }
            if (scoreLevel <= startScoreLevel) continue;
            int levelTotal = endScoreLevel - startScoreLevel;
            int levelDelta = scoreLevel - startScoreLevel;
            double levelTimeGradient = (double)levelDelta / (double)levelTotal;
            timeGradient += levelTimeGradient * levelTimeGradientWeight;
        }
        if (timeGradient > 1.0) {
            timeGradient = 1.0;
        }
        return timeGradient;
    }

    @Override
    public BendableScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new BendableScoreHolder(constraintMatchEnabled, this.hardLevelCount, this.softLevelCount);
    }

    @Override
    public BendableScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, BendableScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        int[] hardScores = new int[this.hardLevelCount];
        for (int i = 0; i < this.hardLevelCount; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getHardScore(i) : Integer.MAX_VALUE;
        }
        int[] softScores = new int[this.softLevelCount];
        for (int i = 0; i < this.softLevelCount; ++i) {
            softScores[i] = trendLevels[this.hardLevelCount + i] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getSoftScore(i) : Integer.MAX_VALUE;
        }
        return BendableScore.valueOf(hardScores, softScores);
    }

    @Override
    public BendableScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, BendableScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        int[] hardScores = new int[this.hardLevelCount];
        for (int i = 0; i < this.hardLevelCount; ++i) {
            hardScores[i] = trendLevels[i] == InitializingScoreTrendLevel.ONLY_UP ? score.getHardScore(i) : Integer.MIN_VALUE;
        }
        int[] softScores = new int[this.softLevelCount];
        for (int i = 0; i < this.softLevelCount; ++i) {
            softScores[i] = trendLevels[this.hardLevelCount + i] == InitializingScoreTrendLevel.ONLY_UP ? score.getSoftScore(i) : Integer.MIN_VALUE;
        }
        return BendableScore.valueOf(hardScores, softScores);
    }
}

