/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreHolder;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class HardSoftBigDecimalScoreDefinition
extends AbstractScoreDefinition<HardSoftBigDecimalScore> {
    private double hardScoreTimeGradientWeight = 0.75;

    public double getHardScoreTimeGradientWeight() {
        return this.hardScoreTimeGradientWeight;
    }

    public void setHardScoreTimeGradientWeight(double hardScoreTimeGradientWeight) {
        this.hardScoreTimeGradientWeight = hardScoreTimeGradientWeight;
        if (hardScoreTimeGradientWeight < 0.0 || hardScoreTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property hardScoreTimeGradientWeight (" + hardScoreTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    @Override
    public int getLevelCount() {
        return 2;
    }

    @Override
    public Class<HardSoftBigDecimalScore> getScoreClass() {
        return HardSoftBigDecimalScore.class;
    }

    @Override
    public HardSoftBigDecimalScore parseScore(String scoreString) {
        return HardSoftBigDecimalScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(HardSoftBigDecimalScore startScore, HardSoftBigDecimalScore endScore, HardSoftBigDecimalScore score) {
        if (score.compareTo(endScore) > 0) {
            return 1.0;
        }
        if (score.compareTo(startScore) < 0) {
            return 0.0;
        }
        double timeGradient = 0.0;
        double softScoreTimeGradientWeight = 1.0 - this.hardScoreTimeGradientWeight;
        if (startScore.getHardScore().compareTo(endScore.getHardScore()) == 0) {
            timeGradient += this.hardScoreTimeGradientWeight;
        } else {
            BigDecimal hardScoreTotal = endScore.getHardScore().subtract(startScore.getHardScore());
            BigDecimal hardScoreDelta = score.getHardScore().subtract(startScore.getHardScore());
            double hardTimeGradient = hardScoreDelta.doubleValue() / hardScoreTotal.doubleValue();
            timeGradient += hardTimeGradient * this.hardScoreTimeGradientWeight;
        }
        if (score.getSoftScore().compareTo(endScore.getSoftScore()) >= 0) {
            timeGradient += softScoreTimeGradientWeight;
        } else if (score.getSoftScore().compareTo(startScore.getSoftScore()) > 0) {
            BigDecimal softScoreTotal = endScore.getSoftScore().subtract(startScore.getSoftScore());
            BigDecimal softScoreDelta = score.getSoftScore().subtract(startScore.getSoftScore());
            double softTimeGradient = softScoreDelta.doubleValue() / softScoreTotal.doubleValue();
            timeGradient += softTimeGradient * softScoreTimeGradientWeight;
        }
        return timeGradient;
    }

    @Override
    public HardSoftBigDecimalScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new HardSoftBigDecimalScoreHolder(constraintMatchEnabled);
    }

    @Override
    public HardSoftBigDecimalScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, HardSoftBigDecimalScore score) {
        throw new UnsupportedOperationException("PLANNER-232: BigDecimalScore does not support bounds because a BigDecimal cannot represent infinity.");
    }

    @Override
    public HardSoftBigDecimalScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, HardSoftBigDecimalScore score) {
        throw new UnsupportedOperationException("PLANNER-232: BigDecimalScore does not support bounds because a BigDecimal cannot represent infinity.");
    }
}

