/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListenerSupport;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.common.TrailingEntityMapSupport;
import org.optaplanner.core.impl.solution.Solution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<F extends AbstractScoreDirectorFactory>
implements ScoreDirector,
Cloneable {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final F scoreDirectorFactory;
    protected boolean constraintMatchEnabledPreference = true;
    protected TrailingEntityMapSupport trailingEntityMapSupport;
    protected VariableListenerSupport variableListenerSupport;
    protected Solution workingSolution;
    protected long workingEntityListRevision = 0L;
    protected boolean allChangesWillBeUndoneBeforeStepEnds = false;
    protected long calculateCount = 0L;

    protected AbstractScoreDirector(F scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        SolutionDescriptor solutionDescriptor = this.getSolutionDescriptor();
        this.trailingEntityMapSupport = new TrailingEntityMapSupport(solutionDescriptor);
        this.variableListenerSupport = solutionDescriptor.buildVariableListenerSupport();
    }

    public F getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    @Override
    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public long getWorkingEntityListRevision() {
        return this.workingEntityListRevision;
    }

    public boolean isAllChangesWillBeUndoneBeforeStepEnds() {
        return this.allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean allChangesWillBeUndoneBeforeStepEnds) {
        this.allChangesWillBeUndoneBeforeStepEnds = allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public long getCalculateCount() {
        return this.calculateCount;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.trailingEntityMapSupport.resetTrailingEntityMap(workingSolution);
        this.setWorkingEntityListDirty();
    }

    @Override
    public boolean isWorkingEntityListDirty(long expectedWorkingEntityListRevision) {
        return this.workingEntityListRevision != expectedWorkingEntityListRevision;
    }

    protected void setWorkingEntityListDirty() {
        ++this.workingEntityListRevision;
    }

    @Override
    public Solution cloneWorkingSolution() {
        return this.getSolutionDescriptor().getSolutionCloner().cloneSolution(this.workingSolution);
    }

    @Override
    public int getWorkingEntityCount() {
        return this.getSolutionDescriptor().getEntityCount(this.workingSolution);
    }

    @Override
    public List<Object> getWorkingEntityList() {
        return this.getSolutionDescriptor().getEntityList(this.workingSolution);
    }

    @Override
    public int getWorkingValueCount() {
        return this.getSolutionDescriptor().getValueCount(this.workingSolution);
    }

    @Override
    public int countWorkingSolutionUninitializedVariables() {
        return this.getSolutionDescriptor().countUninitializedVariables(this.workingSolution);
    }

    @Override
    public boolean isWorkingSolutionInitialized() {
        return this.getSolutionDescriptor().isInitialized(this, this.workingSolution);
    }

    protected void setCalculatedScore(Score score) {
        this.workingSolution.setScore(score);
        ++this.calculateCount;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return false;
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        if (this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("Subclass (" + this.getClass() + ") which overwrote constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") should also overwrite this method.");
        }
        throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled, this method should not be called.");
    }

    @Override
    public AbstractScoreDirector clone() {
        AbstractScoreDirector clone = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector();
        clone.setWorkingSolution(this.cloneWorkingSolution());
        return clone;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object getTrailingEntity(GenuineVariableDescriptor chainedVariableDescriptor, Object planningValue) {
        return this.trailingEntityMapSupport.getTrailingEntity(chainedVariableDescriptor, planningValue);
    }

    @Override
    public final void beforeEntityAdded(Object entity) {
        this.beforeEntityAdded(this.getSolutionDescriptor().getEntityDescriptor(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityAdded(Object entity) {
        this.afterEntityAdded(this.getSolutionDescriptor().getEntityDescriptor(entity.getClass()), entity);
    }

    @Override
    public final void beforeVariableChanged(Object entity, String variableName) {
        GenuineVariableDescriptor variableDescriptor = this.getSolutionDescriptor().findVariableDescriptor(entity, variableName);
        if (variableDescriptor != null) {
            this.beforeVariableChanged(variableDescriptor, entity);
        } else {
            this.beforeShadowVariableChanged(entity, variableName);
        }
    }

    @Override
    public final void afterVariableChanged(Object entity, String variableName) {
        GenuineVariableDescriptor variableDescriptor = this.getSolutionDescriptor().findVariableDescriptor(entity, variableName);
        if (variableDescriptor != null) {
            this.afterVariableChanged(variableDescriptor, entity);
        } else {
            this.afterShadowVariableChanged(entity, variableName);
        }
    }

    @Override
    public final void beforeEntityRemoved(Object entity) {
        this.beforeEntityRemoved(this.getSolutionDescriptor().getEntityDescriptor(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityRemoved(Object entity) {
        this.afterEntityRemoved(this.getSolutionDescriptor().getEntityDescriptor(entity.getClass()), entity);
    }

    public void beforeEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
        this.variableListenerSupport.beforeEntityAdded(this, entityDescriptor, entity);
    }

    public void afterEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
        this.trailingEntityMapSupport.insertInTrailingEntityMap(entityDescriptor, entity);
        this.variableListenerSupport.afterEntityAdded(this, entityDescriptor, entity);
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    public void beforeVariableChanged(GenuineVariableDescriptor variableDescriptor, Object entity) {
        this.trailingEntityMapSupport.retractFromTrailingEntityMap(variableDescriptor, entity);
        this.variableListenerSupport.beforeVariableChanged(this, variableDescriptor, entity);
    }

    public void afterVariableChanged(GenuineVariableDescriptor variableDescriptor, Object entity) {
        this.trailingEntityMapSupport.insertInTrailingEntityMap(variableDescriptor, entity);
        this.variableListenerSupport.afterVariableChanged(this, variableDescriptor, entity);
    }

    public void beforeShadowVariableChanged(Object entity, String variableName) {
    }

    public void afterShadowVariableChanged(Object entity, String variableName) {
    }

    public void beforeEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
        this.trailingEntityMapSupport.retractFromTrailingEntityMap(entityDescriptor, entity);
        this.variableListenerSupport.beforeEntityRemoved(this, entityDescriptor, entity);
    }

    public void afterEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
        this.variableListenerSupport.afterEntityRemoved(this, entityDescriptor, entity);
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.trailingEntityMapSupport.resetTrailingEntityMap(this.workingSolution);
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        this.trailingEntityMapSupport.resetTrailingEntityMap(this.workingSolution);
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.trailingEntityMapSupport.resetTrailingEntityMap(this.workingSolution);
    }

    @Override
    public void assertExpectedWorkingScore(Score expectedWorkingScore, Object completedAction) {
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("Score corruption: the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore  (" + workingScore + ") after completedAction (" + completedAction + ").");
        }
    }

    @Override
    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        ScoreDirectorFactory assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        ScoreDirector uncorruptedScoreDirector = assertionScoreDirectorFactory.buildScoreDirector();
        uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
        Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
        if (!workingScore.equals(uncorruptedScore)) {
            String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector);
            uncorruptedScoreDirector.dispose();
            throw new IllegalStateException("Score corruption: the workingScore (" + workingScore + ") is not the uncorruptedScore (" + uncorruptedScore + ") after completedAction (" + completedAction + "):\n" + scoreCorruptionAnalysis);
        }
        uncorruptedScoreDirector.dispose();
    }

    protected String buildScoreCorruptionAnalysis(ScoreDirector uncorruptedScoreDirector) {
        int count;
        if (!this.isConstraintMatchEnabled() || !uncorruptedScoreDirector.isConstraintMatchEnabled()) {
            return "  Score corruption analysis could not be generated because either corrupted constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") or uncorrupted constraintMatchEnabled (" + uncorruptedScoreDirector.isConstraintMatchEnabled() + ") is disabled.\n" + "  Check your score constraints manually.";
        }
        Collection<ConstraintMatchTotal> corruptedConstraintMatchTotals = this.getConstraintMatchTotals();
        Collection<ConstraintMatchTotal> uncorruptedConstraintMatchTotals = uncorruptedScoreDirector.getConstraintMatchTotals();
        Map<List<Object>, ConstraintMatch> corruptedMap = this.createConstraintMatchMap(corruptedConstraintMatchTotals);
        LinkedHashMap<List<Object>, ConstraintMatch> excessMap = new LinkedHashMap<List<Object>, ConstraintMatch>(corruptedMap);
        Map<List<Object>, ConstraintMatch> missingMap = this.createConstraintMatchMap(uncorruptedConstraintMatchTotals);
        excessMap.keySet().removeAll(missingMap.keySet());
        missingMap.keySet().removeAll(corruptedMap.keySet());
        int CONSTRAINT_MATCH_DISPLAY_LIMIT = 8;
        StringBuilder analysis = new StringBuilder();
        if (excessMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) which are in excess.\n");
        } else {
            analysis.append("  The corrupted scoreDirector has ").append(excessMap.size()).append(" ConstraintMatch(s) which are in excess (and should not be there):\n");
            count = 0;
            for (ConstraintMatch constraintMatch : excessMap.values()) {
                if (count >= 8) {
                    analysis.append("    ... ").append(excessMap.size() - 8).append(" more\n");
                    break;
                }
                analysis.append("    ").append(constraintMatch).append("\n");
                ++count;
            }
        }
        if (missingMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) which are missing.\n");
        } else {
            analysis.append("  The corrupted scoreDirector has ").append(missingMap.size()).append(" ConstraintMatch(s) which are missing:\n");
            count = 0;
            for (ConstraintMatch constraintMatch : missingMap.values()) {
                if (count >= 8) {
                    analysis.append("    ... ").append(missingMap.size() - 8).append(" more\n");
                    break;
                }
                analysis.append("    ").append(constraintMatch).append("\n");
                ++count;
            }
        }
        if (excessMap.isEmpty() && missingMap.isEmpty()) {
            analysis.append("  The corrupted scoreDirector has no ConstraintMatch(s) in excess or missing. That could be a bug in this class (").append(this.getClass()).append(").\n");
        }
        analysis.append("  Check your score constraints.");
        return analysis.toString();
    }

    private Map<List<Object>, ConstraintMatch> createConstraintMatchMap(Collection<ConstraintMatchTotal> constraintMatchTotals) {
        LinkedHashMap<List<Object>, ConstraintMatch> constraintMatchMap = new LinkedHashMap<List<Object>, ConstraintMatch>(constraintMatchTotals.size() * 16);
        for (ConstraintMatchTotal constraintMatchTotal : constraintMatchTotals) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                ConstraintMatch previousConstraintMatch = constraintMatchMap.put(Arrays.asList(constraintMatchTotal.getConstraintPackage(), constraintMatchTotal.getConstraintName(), constraintMatchTotal.getScoreLevel(), constraintMatch.getJustificationList(), constraintMatch.getWeightAsNumber()), constraintMatch);
                if (previousConstraintMatch == null) continue;
                throw new IllegalStateException("Score corruption because the constraintMatch (" + constraintMatch + ") was added twice for constraintMatchTotal (" + constraintMatchTotal + ") without removal.");
            }
        }
        return constraintMatchMap;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculateCount + ")";
    }
}

