/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.trend;

import java.io.Serializable;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrendLevel;

public class InitializingScoreTrend
implements Serializable {
    private final InitializingScoreTrendLevel[] trendLevels;

    public static InitializingScoreTrend parseTrend(String initializingScoreTrendString, int levelsSize) {
        boolean tokenIsSingle;
        String[] trendTokens = initializingScoreTrendString.split("/");
        boolean bl = tokenIsSingle = trendTokens.length == 1;
        if (!tokenIsSingle && trendTokens.length != levelsSize) {
            throw new IllegalArgumentException("The initializingScoreTrendString (" + initializingScoreTrendString + ") doesn't follow the correct pattern (" + InitializingScoreTrend.buildTrendPattern(levelsSize) + "):" + " the trendTokens length (" + trendTokens.length + ") differs from the levelsSize (" + levelsSize + ").");
        }
        InitializingScoreTrendLevel[] trendLevels = new InitializingScoreTrendLevel[levelsSize];
        for (int i = 0; i < levelsSize; ++i) {
            trendLevels[i] = InitializingScoreTrendLevel.valueOf(trendTokens[tokenIsSingle ? 0 : i]);
        }
        return new InitializingScoreTrend(trendLevels);
    }

    protected static String buildTrendPattern(int levelsSize) {
        StringBuilder trendPattern = new StringBuilder(levelsSize * 4);
        boolean first = true;
        for (int i = 0; i < levelsSize; ++i) {
            if (first) {
                first = false;
            } else {
                trendPattern.append("/");
            }
            trendPattern.append(InitializingScoreTrendLevel.ANY.name());
        }
        return trendPattern.toString();
    }

    public InitializingScoreTrend(InitializingScoreTrendLevel[] trendLevels) {
        this.trendLevels = trendLevels;
    }

    public InitializingScoreTrendLevel[] getTrendLevels() {
        return this.trendLevels;
    }

    public int getLevelCount() {
        return this.trendLevels.length;
    }

    public boolean isOnlyUp() {
        for (InitializingScoreTrendLevel trendLevel : this.trendLevels) {
            if (trendLevel == InitializingScoreTrendLevel.ONLY_UP) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyDown() {
        for (InitializingScoreTrendLevel trendLevel : this.trendLevels) {
            if (trendLevel == InitializingScoreTrendLevel.ONLY_DOWN) continue;
            return false;
        }
        return true;
    }
}

