/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.phase.SolverPhase;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.BasicPlumbingTermination;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.core.impl.solver.event.SolverEventSupport;
import org.optaplanner.core.impl.solver.random.RandomFactory;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSolver
implements Solver {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverEventSupport solverEventSupport = new SolverEventSupport(this);
    protected ScoreDirectorFactory scoreDirectorFactory;
    protected RandomFactory randomFactory;
    protected BasicPlumbingTermination basicPlumbingTermination;
    protected Termination termination;
    protected BestSolutionRecaller bestSolutionRecaller;
    protected List<SolverPhase> solverPhaseList;
    protected AtomicBoolean solving = new AtomicBoolean(false);
    protected DefaultSolverScope solverScope = new DefaultSolverScope();

    public RandomFactory getRandomFactory() {
        return this.randomFactory;
    }

    public void setRandomFactory(RandomFactory randomFactory) {
        this.randomFactory = randomFactory;
    }

    @Override
    public ScoreDirectorFactory getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    public void setScoreDirectorFactory(ScoreDirectorFactory scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
    }

    public void setBasicPlumbingTermination(BasicPlumbingTermination basicPlumbingTermination) {
        this.basicPlumbingTermination = basicPlumbingTermination;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.bestSolutionRecaller.setSolverEventSupport(this.solverEventSupport);
    }

    public List<SolverPhase> getSolverPhaseList() {
        return this.solverPhaseList;
    }

    public void setSolverPhaseList(List<SolverPhase> solverPhaseList) {
        this.solverPhaseList = solverPhaseList;
    }

    @Override
    public Solution getBestSolution() {
        return this.solverScope.getBestSolution();
    }

    @Override
    public long getTimeMillisSpent() {
        Long endingSystemTimeMillis = this.solverScope.getEndingSystemTimeMillis();
        if (endingSystemTimeMillis == null) {
            endingSystemTimeMillis = System.currentTimeMillis();
        }
        return endingSystemTimeMillis - this.solverScope.getStartingSystemTimeMillis();
    }

    public DefaultSolverScope getSolverScope() {
        return this.solverScope;
    }

    @Override
    public boolean isSolving() {
        return this.solving.get();
    }

    @Override
    public boolean terminateEarly() {
        return this.basicPlumbingTermination.terminateEarly();
    }

    @Override
    public boolean isTerminateEarly() {
        return this.basicPlumbingTermination.isTerminateEarly();
    }

    @Override
    public boolean addProblemFactChange(ProblemFactChange problemFactChange) {
        return this.basicPlumbingTermination.addProblemFactChange(problemFactChange);
    }

    @Override
    public boolean isEveryProblemFactChangeProcessed() {
        BlockingQueue<ProblemFactChange> problemFactChangeQueue = this.basicPlumbingTermination.getProblemFactChangeQueue();
        return problemFactChangeQueue.isEmpty();
    }

    @Override
    public final void solve(Solution planningProblem) {
        if (planningProblem == null) {
            throw new IllegalArgumentException("The planningProblem (" + planningProblem + ") must not be null.");
        }
        this.solverScope.setBestSolution(planningProblem);
        this.outerSolvingStarted(this.solverScope);
        boolean restartSolver = true;
        while (restartSolver) {
            this.solvingStarted(this.solverScope);
            this.runSolverPhases();
            this.solvingEnded(this.solverScope);
            restartSolver = this.checkProblemFactChanges();
        }
        this.outerSolvingEnded(this.solverScope);
    }

    public void outerSolvingStarted(DefaultSolverScope solverScope) {
        this.solving.set(true);
        this.basicPlumbingTermination.resetTerminateEarly();
        solverScope.setStartingSystemTimeMillis(System.currentTimeMillis());
        solverScope.setEndingSystemTimeMillis(null);
        solverScope.setStartingSolverCount(0);
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        solverScope.setScoreDirector(this.scoreDirectorFactory.buildScoreDirector());
        solverScope.setWorkingRandom(this.randomFactory.createRandom());
        solverScope.setWorkingSolutionFromBestSolution();
        this.bestSolutionRecaller.solvingStarted(solverScope);
        for (SolverPhase solverPhase : this.solverPhaseList) {
            solverPhase.solvingStarted(solverScope);
        }
        int startingSolverCount = solverScope.getStartingSolverCount() + 1;
        solverScope.setStartingSolverCount(startingSolverCount);
        this.logger.info("Solving {}: time spent ({}), best score ({}), random ({}).", new Object[]{startingSolverCount == 1 ? "started" : "restarted", solverScope.calculateTimeMillisSpent(), solverScope.getBestScoreWithUninitializedPrefix(), this.randomFactory != null ? this.randomFactory : "not fixed"});
    }

    protected void runSolverPhases() {
        Iterator<SolverPhase> it = this.solverPhaseList.iterator();
        while (!this.termination.isSolverTerminated(this.solverScope) && it.hasNext()) {
            SolverPhase solverPhase = it.next();
            solverPhase.solve(this.solverScope);
            if (!it.hasNext()) continue;
            this.solverScope.setWorkingSolutionFromBestSolution();
        }
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        for (SolverPhase solverPhase : this.solverPhaseList) {
            solverPhase.solvingEnded(solverScope);
        }
        this.bestSolutionRecaller.solvingEnded(solverScope);
    }

    public void outerSolvingEnded(DefaultSolverScope solverScope) {
        solverScope.getScoreDirector().dispose();
        solverScope.setEndingSystemTimeMillis(System.currentTimeMillis());
        long timeMillisSpent = this.getTimeMillisSpent();
        long averageCalculateCountPerSecond = solverScope.getCalculateCount() * 1000L / (timeMillisSpent == 0L ? 1L : timeMillisSpent);
        this.logger.info("Solving ended: time spent ({}), best score ({}), average calculate count per second ({}).", new Object[]{timeMillisSpent, solverScope.getBestScoreWithUninitializedPrefix(), averageCalculateCountPerSecond});
        this.solving.set(false);
    }

    private boolean checkProblemFactChanges() {
        BlockingQueue<ProblemFactChange> problemFactChangeQueue = this.basicPlumbingTermination.getProblemFactChangeQueue();
        if (problemFactChangeQueue.isEmpty()) {
            return false;
        }
        this.solverScope.setWorkingSolutionFromBestSolution();
        Score score = null;
        int stepIndex = 0;
        ProblemFactChange problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
        while (problemFactChange != null) {
            score = this.doProblemFactChange(problemFactChange, stepIndex);
            ++stepIndex;
            problemFactChange = (ProblemFactChange)problemFactChangeQueue.poll();
        }
        Solution newBestSolution = this.solverScope.getScoreDirector().cloneWorkingSolution();
        int newBestUninitializedVariableCount = this.solverScope.getSolutionDescriptor().countUninitializedVariables(newBestSolution);
        this.bestSolutionRecaller.updateBestSolution(this.solverScope, newBestSolution, newBestUninitializedVariableCount);
        this.logger.info("Real-time problem fact changes done: step total ({}), new {} best score ({}).", new Object[]{stepIndex, newBestUninitializedVariableCount <= 0 ? "initialized" : "uninitialized", score});
        return true;
    }

    private Score doProblemFactChange(ProblemFactChange problemFactChange, int stepIndex) {
        problemFactChange.doChange(this.solverScope.getScoreDirector());
        Score score = this.solverScope.calculateScore();
        this.logger.debug("    Step index ({}), new score ({}) for real-time problem fact change.", (Object)stepIndex, (Object)score);
        return score;
    }

    @Override
    public void addEventListener(SolverEventListener eventListener) {
        this.solverEventSupport.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(SolverEventListener eventListener) {
        this.solverEventSupport.removeEventListener(eventListener);
    }

    public void addSolverPhaseLifecycleListener(SolverPhaseLifecycleListener solverPhaseLifecycleListener) {
        for (SolverPhase solverPhase : this.solverPhaseList) {
            solverPhase.addSolverPhaseLifecycleListener(solverPhaseLifecycleListener);
        }
    }

    public void removeSolverPhaseLifecycleListener(SolverPhaseLifecycleListener solverPhaseLifecycleListener) {
        for (SolverPhase solverPhase : this.solverPhaseList) {
            solverPhase.addSolverPhaseLifecycleListener(solverPhaseLifecycleListener);
        }
    }
}

