/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.recaller;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.event.SolverEventSupport;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestSolutionRecaller
extends SolverPhaseLifecycleListenerAdapter {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean assertBestScoreIsUnmodified = false;
    protected SolverEventSupport solverEventSupport;

    public void setAssertBestScoreIsUnmodified(boolean assertBestScoreIsUnmodified) {
        this.assertBestScoreIsUnmodified = assertBestScoreIsUnmodified;
    }

    public void setSolverEventSupport(SolverEventSupport solverEventSupport) {
        this.solverEventSupport = solverEventSupport;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        int uninitializedVariableCount = solverScope.getScoreDirector().countWorkingSolutionUninitializedVariables();
        solverScope.setBestUninitializedVariableCount(uninitializedVariableCount);
        Score score = solverScope.calculateScore();
        solverScope.setBestScore(score);
        solverScope.setBestSolutionTimeMillis(System.currentTimeMillis());
        solverScope.getBestSolution().setScore(score);
        if (uninitializedVariableCount == 0) {
            solverScope.setStartingInitializedScore(score);
        } else {
            solverScope.setStartingInitializedScore(null);
        }
    }

    public void processWorkingSolutionDuringStep(AbstractStepScope stepScope) {
        AbstractSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        int uninitializedVariableCount = stepScope.getUninitializedVariableCount();
        Score score = stepScope.getScore();
        DefaultSolverScope solverScope = phaseScope.getSolverScope();
        int bestUninitializedVariableCount = solverScope.getBestUninitializedVariableCount();
        Score bestScore = solverScope.getBestScore();
        boolean bestScoreImproved = uninitializedVariableCount == bestUninitializedVariableCount ? score.compareTo(bestScore) > 0 : uninitializedVariableCount < bestUninitializedVariableCount;
        stepScope.setBestScoreImproved(bestScoreImproved);
        if (bestScoreImproved) {
            phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution newBestSolution = stepScope.createOrGetClonedSolution();
            this.updateBestSolution(solverScope, newBestSolution, uninitializedVariableCount);
        } else if (this.assertBestScoreIsUnmodified) {
            solverScope.assertScoreFromScratch(solverScope.getBestSolution());
        }
    }

    public void processWorkingSolutionDuringMove(int uninitializedVariableCount, Score score, AbstractStepScope stepScope) {
        boolean bestScoreImproved;
        AbstractSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        DefaultSolverScope solverScope = phaseScope.getSolverScope();
        int bestUninitializedVariableCount = solverScope.getBestUninitializedVariableCount();
        Score bestScore = solverScope.getBestScore();
        if (uninitializedVariableCount == bestUninitializedVariableCount) {
            bestScoreImproved = score.compareTo(bestScore) > 0;
        } else {
            boolean bl = bestScoreImproved = uninitializedVariableCount < bestUninitializedVariableCount;
        }
        if (bestScoreImproved) {
            stepScope.setBestScoreImproved(bestScoreImproved);
        }
        if (bestScoreImproved) {
            phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
            this.updateBestSolution(solverScope, newBestSolution, uninitializedVariableCount);
        } else if (this.assertBestScoreIsUnmodified) {
            solverScope.assertScoreFromScratch(solverScope.getBestSolution());
        }
    }

    public void updateBestSolution(DefaultSolverScope solverScope, Solution solution, int uninitializedVariableCount) {
        if (uninitializedVariableCount == 0 && !solverScope.isBestSolutionInitialized()) {
            solverScope.setStartingInitializedScore((Score)solution.getScore());
        }
        solverScope.setBestUninitializedVariableCount(uninitializedVariableCount);
        solverScope.setBestSolution(solution);
        solverScope.setBestScore((Score)solution.getScore());
        solverScope.setBestSolutionTimeMillis(System.currentTimeMillis());
        this.solverEventSupport.fireBestSolutionChanged(solution);
    }
}

