/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.placer.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.constructionheuristic.placer.Placement;
import org.optaplanner.core.impl.constructionheuristic.placer.QueuedEntityPlacer;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicRecordingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.composite.CartesianProductMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.multivar.TestdataMultiVarEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class QueuedEntityPlacerTest {
    @Test
    public void oneMoveSelector() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"));
        MimicRecordingEntitySelector recordingEntitySelector = new MimicRecordingEntitySelector(entitySelector);
        ValueSelector valueSelector = SelectorTestUtils.mockValueSelector(TestdataEntity.class, "value", new TestdataValue("1"), new TestdataValue("2"));
        ChangeMoveSelector moveSelector = new ChangeMoveSelector((EntitySelector)new MimicReplayingEntitySelector((EntityMimicRecorder)recordingEntitySelector), valueSelector, false);
        QueuedEntityPlacer placer = new QueuedEntityPlacer((EntitySelector)recordingEntitySelector, Collections.singletonList(moveSelector));
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        placer.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        placer.phaseStarted(phaseScopeA);
        Iterator placementIterator = placer.iterator();
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA1);
        this.assertPlacement((Placement)placementIterator.next(), "a", "1", "2");
        placer.stepEnded(stepScopeA1);
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA2);
        this.assertPlacement((Placement)placementIterator.next(), "b", "1", "2");
        placer.stepEnded(stepScopeA2);
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA3.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA3);
        this.assertPlacement((Placement)placementIterator.next(), "c", "1", "2");
        placer.stepEnded(stepScopeA3);
        Assert.assertFalse((boolean)placementIterator.hasNext());
        placer.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        placer.phaseStarted(phaseScopeB);
        placementIterator = placer.iterator();
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        placer.stepStarted(stepScopeB1);
        this.assertPlacement((Placement)placementIterator.next(), "a", "1", "2");
        placer.stepEnded(stepScopeB1);
        placer.phaseEnded(phaseScopeB);
        placer.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 4);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 4);
    }

    @Test
    public void multiQueuedMoveSelector() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataMultiVarEntity.class, new TestdataMultiVarEntity("a"), new TestdataMultiVarEntity("b"));
        MimicRecordingEntitySelector recordingEntitySelector = new MimicRecordingEntitySelector(entitySelector);
        ValueSelector primaryValueSelector = SelectorTestUtils.mockValueSelector(TestdataMultiVarEntity.class, "primaryValue", new TestdataValue("1"), new TestdataValue("2"), new TestdataValue("3"));
        ValueSelector secondaryValueSelector = SelectorTestUtils.mockValueSelector(TestdataMultiVarEntity.class, "secondaryValue", new TestdataValue("8"), new TestdataValue("9"));
        ArrayList<ChangeMoveSelector> moveSelectorList = new ArrayList<ChangeMoveSelector>(2);
        moveSelectorList.add(new ChangeMoveSelector((EntitySelector)new MimicReplayingEntitySelector((EntityMimicRecorder)recordingEntitySelector), primaryValueSelector, false));
        moveSelectorList.add(new ChangeMoveSelector((EntitySelector)new MimicReplayingEntitySelector((EntityMimicRecorder)recordingEntitySelector), secondaryValueSelector, false));
        QueuedEntityPlacer placer = new QueuedEntityPlacer((EntitySelector)recordingEntitySelector, moveSelectorList);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        placer.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        placer.phaseStarted(phaseScopeA);
        Iterator placementIterator = placer.iterator();
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA1);
        this.assertPlacement((Placement)placementIterator.next(), "a", "1", "2", "3");
        placer.stepEnded(stepScopeA1);
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA2);
        this.assertPlacement((Placement)placementIterator.next(), "a", "8", "9");
        placer.stepEnded(stepScopeA2);
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA3.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA3);
        this.assertPlacement((Placement)placementIterator.next(), "b", "1", "2", "3");
        placer.stepEnded(stepScopeA3);
        Assert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA4 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA4.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA4);
        this.assertPlacement((Placement)placementIterator.next(), "b", "8", "9");
        placer.stepEnded(stepScopeA4);
        Assert.assertFalse((boolean)placementIterator.hasNext());
        placer.phaseEnded(phaseScopeA);
        placer.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 1, 4);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)primaryValueSelector, 1, 1, 4);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)secondaryValueSelector, 1, 1, 4);
    }

    private void assertPlacement(Placement placement, String entityCode, String ... valueCodes) {
        Iterator iterator = placement.iterator();
        Assert.assertNotNull((Object)iterator);
        for (String valueCode : valueCodes) {
            Assert.assertTrue((boolean)iterator.hasNext());
            ChangeMove move = (ChangeMove)iterator.next();
            PlannerAssert.assertCode(entityCode, move.getEntity());
            PlannerAssert.assertCode(valueCode, move.getToPlanningValue());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void cartesianProductMoveSelector() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataMultiVarEntity.class, new TestdataMultiVarEntity("a"), new TestdataMultiVarEntity("b"));
        MimicRecordingEntitySelector recordingEntitySelector = new MimicRecordingEntitySelector(entitySelector);
        ValueSelector primaryValueSelector = SelectorTestUtils.mockValueSelector(TestdataMultiVarEntity.class, "primaryValue", new TestdataValue("1"), new TestdataValue("2"), new TestdataValue("3"));
        ValueSelector secondaryValueSelector = SelectorTestUtils.mockValueSelector(TestdataMultiVarEntity.class, "secondaryValue", new TestdataValue("8"), new TestdataValue("9"));
        ArrayList<ChangeMoveSelector> moveSelectorList = new ArrayList<ChangeMoveSelector>(2);
        moveSelectorList.add(new ChangeMoveSelector((EntitySelector)new MimicReplayingEntitySelector((EntityMimicRecorder)recordingEntitySelector), primaryValueSelector, false));
        moveSelectorList.add(new ChangeMoveSelector((EntitySelector)new MimicReplayingEntitySelector((EntityMimicRecorder)recordingEntitySelector), secondaryValueSelector, false));
        CartesianProductMoveSelector moveSelector = new CartesianProductMoveSelector(moveSelectorList, true, false);
        QueuedEntityPlacer placer = new QueuedEntityPlacer((EntitySelector)recordingEntitySelector, Collections.singletonList(moveSelector));
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        placer.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        placer.phaseStarted(phaseScopeA);
        Iterator placementIterator = placer.iterator();
        Assert.assertEquals((Object)true, (Object)placementIterator.hasNext());
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfIterator(((Placement)placementIterator.next()).iterator(), "a->1+a->8", "a->1+a->9", "a->2+a->8", "a->2+a->9", "a->3+a->8", "a->3+a->9");
        placer.stepEnded(stepScopeA1);
        Assert.assertEquals((Object)true, (Object)placementIterator.hasNext());
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfIterator(((Placement)placementIterator.next()).iterator(), "b->1+b->8", "b->1+b->9", "b->2+b->8", "b->2+b->9", "b->3+b->8", "b->3+b->9");
        placer.stepEnded(stepScopeA2);
        Assert.assertEquals((Object)false, (Object)placementIterator.hasNext());
        placer.phaseEnded(phaseScopeA);
        placer.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 1, 2);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)primaryValueSelector, 1, 1, 2);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)secondaryValueSelector, 1, 1, 2);
    }
}

