/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.decorator;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.SortingEntitySelector;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class SortingEntitySelectorTest {
    @Test
    public void cacheTypeSolver() {
        this.runCacheType(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void cacheTypePhase() {
        this.runCacheType(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void cacheTypeStep() {
        this.runCacheType(SelectionCacheType.STEP, 5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cacheTypeJustInTime() {
        this.runCacheType(SelectionCacheType.JUST_IN_TIME, 5);
    }

    public void runCacheType(SelectionCacheType cacheType, int timesCalled) {
        EntitySelector childEntitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("jan"), new TestdataEntity("feb"), new TestdataEntity("mar"), new TestdataEntity("apr"), new TestdataEntity("may"), new TestdataEntity("jun"));
        SelectionSorter<TestdataEntity> sorter = new SelectionSorter<TestdataEntity>(){

            public void sort(ScoreDirector scoreDirector, List<TestdataEntity> selectionList) {
                Collections.sort(selectionList, new Comparator<TestdataEntity>(){

                    @Override
                    public int compare(TestdataEntity a, TestdataEntity b) {
                        return a.getCode().compareTo(b.getCode());
                    }
                });
            }
        };
        SortingEntitySelector entitySelector = new SortingEntitySelector(childEntitySelector, cacheType, (SelectionSorter)sorter);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        entitySelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "apr", "feb", "jan", "jun", "mar", "may");
        entitySelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "apr", "feb", "jan", "jun", "mar", "may");
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "apr", "feb", "jan", "jun", "mar", "may");
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "apr", "feb", "jan", "jun", "mar", "may");
        entitySelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "apr", "feb", "jan", "jun", "mar", "may");
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childEntitySelector, 1, 2, 5);
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }
}

