/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ChangeMoveSelectorTest {
    @Test
    public void original() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        ValueSelector valueSelector = SelectorTestUtils.mockValueSelector(TestdataEntity.class, "value", new TestdataValue("1"), new TestdataValue("2"), new TestdataValue("3"));
        ChangeMoveSelector moveSelector = new ChangeMoveSelector(entitySelector, valueSelector, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a->1", "a->2", "a->3", "b->1", "b->2", "b->3", "c->1", "c->2", "c->3", "d->1", "d->2", "d->3");
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a->1", "a->2", "a->3", "b->1", "b->2", "b->3", "c->1", "c->2", "c->3", "d->1", "d->2", "d->3");
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a->1", "a->2", "a->3", "b->1", "b->2", "b->3", "c->1", "c->2", "c->3", "d->1", "d->2", "d->3");
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a->1", "a->2", "a->3", "b->1", "b->2", "b->3", "c->1", "c->2", "c->3", "d->1", "d->2", "d->3");
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, "a->1", "a->2", "a->3", "b->1", "b->2", "b->3", "c->1", "c->2", "c->3", "d->1", "d->2", "d->3");
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 5);
    }

    @Test
    public void emptyEntitySelectorOriginal() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new Object[0]);
        ValueSelector valueSelector = SelectorTestUtils.mockValueSelector(TestdataEntity.class, "value", new TestdataValue("1"), new TestdataValue("2"), new TestdataValue("3"));
        ChangeMoveSelector moveSelector = new ChangeMoveSelector(entitySelector, valueSelector, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 5);
    }

    @Test
    public void emptyValueSelectorOriginal() {
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("a"), new TestdataEntity("b"), new TestdataEntity("c"), new TestdataEntity("d"));
        ValueSelector valueSelector = SelectorTestUtils.mockValueSelector(TestdataEntity.class, "value", new Object[0]);
        ChangeMoveSelector moveSelector = new ChangeMoveSelector(entitySelector, valueSelector, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        moveSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeA2);
        moveSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        moveSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        moveSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfMoveSelector((MoveSelector)moveSelector, new String[0]);
        moveSelector.stepEnded(stepScopeB3);
        moveSelector.phaseEnded(phaseScopeB);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)entitySelector, 1, 2, 5);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)valueSelector, 1, 2, 5);
    }
}

