/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.InitializedValueSelector;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.nullable.TestdataNullableEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class InitializedValueSelectorTest {
    @Test
    public void originalSelectionNullable() {
        EntityDescriptor entityDescriptor = TestdataNullableEntity.buildEntityDescriptor();
        TestdataNullableEntity e1 = new TestdataNullableEntity("e1");
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor("value");
        TestdataValue v1 = new TestdataValue("v1");
        Object v2 = null;
        TestdataValue v3 = new TestdataValue("v3");
        ValueSelector childValueSelector = SelectorTestUtils.mockValueSelector(variableDescriptor, v1, v2, v3);
        InitializedValueSelector valueSelector = new InitializedValueSelector(childValueSelector);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)1))).isNeverEnding();
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)e1, Long.MIN_VALUE, "v1", null, "v3");
        e1.setValue(v1);
        valueSelector.stepEnded(stepScopeA1);
        valueSelector.phaseEnded(phaseScopeA);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 1, 1);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)1))).iterator(Mockito.any());
    }

    @Test
    public void originalSelectionChained() {
        EntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor("chainedObject");
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1");
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2");
        ValueSelector childValueSelector = SelectorTestUtils.mockValueSelector(variableDescriptor, a0, a1, a2);
        InitializedValueSelector valueSelector = new InitializedValueSelector(childValueSelector);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)1))).isNeverEnding();
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)a1, Long.MIN_VALUE, "a0");
        a1.setChainedObject(a0);
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)a2, Long.MIN_VALUE, "a0", "a1");
        a2.setChainedObject(a1);
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)a1, Long.MIN_VALUE, "a0", "a1", "a2");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)a2, Long.MIN_VALUE, "a0", "a1", "a2");
        valueSelector.stepEnded(stepScopeB2);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 4);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)4))).iterator(Mockito.any());
    }
}

