/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SelectedCountLimitValueSelector;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class SelectedCountLimitValueSelectorTest {
    @Test
    public void selectSizeLimitLowerThanSelectorSize() {
        EntityIndependentValueSelector childValueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(TestdataValue.class, "value", new TestdataValue("v1"), new TestdataValue("v2"), new TestdataValue("v3"), new TestdataValue("v4"), new TestdataValue("v5"));
        SelectedCountLimitValueSelector valueSelector = new SelectedCountLimitValueSelector((ValueSelector)childValueSelector, 3L);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB3);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 5);
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)5))).iterator();
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)5))).getSize();
    }

    @Test
    public void selectSizeLimitHigherThanSelectorSize() {
        EntityIndependentValueSelector childValueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(TestdataValue.class, "value", new TestdataValue("v1"), new TestdataValue("v2"), new TestdataValue("v3"));
        SelectedCountLimitValueSelector valueSelector = new SelectedCountLimitValueSelector((ValueSelector)childValueSelector, 5L);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB3);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 5);
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)5))).iterator();
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)5))).getSize();
    }

    @Test
    public void selectSizeLimitLowerThanSelectorSizeEntityDependent() {
        TestdataEntity entity = new TestdataEntity("e1");
        ValueSelector childValueSelector = SelectorTestUtils.mockValueSelectorForEntity(TestdataValue.class, (Object)entity, "value", new TestdataValue("v1"), new TestdataValue("v2"), new TestdataValue("v3"), new TestdataValue("v4"), new TestdataValue("v5"));
        SelectedCountLimitValueSelector valueSelector = new SelectedCountLimitValueSelector(childValueSelector, 3L);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB3);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 5);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)5))).iterator((Object)entity);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)5))).getSize((Object)entity);
    }

    @Test
    public void selectSizeLimitHigherThanSelectorSizeEntityDependent() {
        TestdataEntity entity = new TestdataEntity("e1");
        ValueSelector childValueSelector = SelectorTestUtils.mockValueSelectorForEntity(TestdataValue.class, (Object)entity, "value", new TestdataValue("v1"), new TestdataValue("v2"), new TestdataValue("v3"));
        SelectedCountLimitValueSelector valueSelector = new SelectedCountLimitValueSelector(childValueSelector, 5L);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfValueSelectorForEntity((ValueSelector)valueSelector, (Object)entity, "v1", "v2", "v3");
        valueSelector.stepEnded(stepScopeB3);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 5);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)5))).iterator((Object)entity);
        ((ValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)5))).getSize((Object)entity);
    }
}

