/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.comparator.NaturalScoreComparator;
import org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator.ShiftingHardPenaltyDeciderScoreComparatorFactory;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.comparator.FlatteningHardSoftScoreComparator;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class ShiftingHardPenaltyDeciderScoreComparatorFactoryTest {
    @Test
    public void shiftingPenaltyActiveAndHardWeight() {
        ShiftingHardPenaltyDeciderScoreComparatorFactory deciderScoreComparatorFactory = new ShiftingHardPenaltyDeciderScoreComparatorFactory();
        deciderScoreComparatorFactory.setHardScoreActivationThreshold(-10);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeMinimum(1);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeMaximum(3);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeRepetitionMultiplicand(5.0);
        deciderScoreComparatorFactory.setHardWeightSurvivalRatio(0.9);
        LocalSearchSolverPhaseScope phaseScope = this.createPhaseScope();
        deciderScoreComparatorFactory.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = phaseScope.getLastCompletedStepScope();
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.stepStarted(stepScope);
        Assert.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        stepScope.setScore((Score)HardSoftScore.valueOf((int)-11, (int)-200));
        deciderScoreComparatorFactory.stepEnded(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.stepStarted(stepScope);
        Assert.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        stepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
        deciderScoreComparatorFactory.stepEnded(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.stepStarted(stepScope);
        Assert.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        stepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.stepStarted(stepScope);
        Assert.assertEquals((long)1000L, (long)((FlatteningHardSoftScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        stepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.stepStarted(stepScope);
        Assert.assertEquals((long)900L, (long)((FlatteningHardSoftScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        stepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.stepStarted(stepScope);
        Assert.assertEquals((long)810L, (long)((FlatteningHardSoftScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        stepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.stepStarted(stepScope);
        Assert.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        stepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.stepStarted(stepScope);
        Assert.assertEquals((long)1000L, (long)((FlatteningHardSoftScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        stepScope.setScore((Score)HardSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepEnded(stepScope);
    }

    private LocalSearchStepScope nextStepScope(LocalSearchStepScope lastCompletedStepScope) {
        LocalSearchSolverPhaseScope phaseScope = lastCompletedStepScope.getPhaseScope();
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        return new LocalSearchStepScope(phaseScope);
    }

    private LocalSearchSolverPhaseScope createPhaseScope() {
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)HardSoftScore.valueOf((int)-11, (int)-200));
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        phaseScope.setBestSolutionStepIndex(1000);
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, 1000);
        lastCompletedStepScope.setScore((Score)HardSoftScore.valueOf((int)-11, (int)-200));
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        return phaseScope;
    }
}

