/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.forager;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.heuristic.move.DummyMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactory;
import org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator.NaturalDeciderScoreComparatorFactory;
import org.optaplanner.core.impl.localsearch.decider.forager.AcceptedForager;
import org.optaplanner.core.impl.localsearch.decider.forager.PickEarlyType;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

public class AcceptedForagerTest {
    @Test
    public void pickMoveMaxScoreAccepted() {
        AcceptedForager forager = new AcceptedForager((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory(), PickEarlyType.NEVER, Integer.MAX_VALUE);
        LocalSearchSolverPhaseScope phaseScope = this.createPhaseScope();
        forager.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = this.createStepScope(phaseScope);
        forager.stepStarted(stepScope);
        LocalSearchMoveScope a = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-20), true);
        LocalSearchMoveScope b = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1), false);
        LocalSearchMoveScope c = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-20), false);
        LocalSearchMoveScope d = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-2), true);
        LocalSearchMoveScope e = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-300), true);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(e);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(stepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        forager.phaseEnded(phaseScope);
    }

    @Test
    public void pickMoveMaxScoreUnaccepted() {
        AcceptedForager forager = new AcceptedForager((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory(), PickEarlyType.NEVER, Integer.MAX_VALUE);
        LocalSearchSolverPhaseScope phaseScope = this.createPhaseScope();
        forager.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = this.createStepScope(phaseScope);
        forager.stepStarted(stepScope);
        LocalSearchMoveScope a = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-20), false);
        LocalSearchMoveScope b = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1), false);
        LocalSearchMoveScope c = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-20), false);
        LocalSearchMoveScope d = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-2), false);
        LocalSearchMoveScope e = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-300), false);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(e);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(stepScope);
        Assert.assertSame((Object)b, (Object)pickedScope);
        forager.phaseEnded(phaseScope);
    }

    @Test
    public void pickMoveFirstBestScoreImproving() {
        AcceptedForager forager = new AcceptedForager((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory(), PickEarlyType.FIRST_BEST_SCORE_IMPROVING, Integer.MAX_VALUE);
        LocalSearchSolverPhaseScope phaseScope = this.createPhaseScope();
        forager.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = this.createStepScope(phaseScope);
        forager.stepStarted(stepScope);
        LocalSearchMoveScope a = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1), false);
        LocalSearchMoveScope b = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-20), true);
        LocalSearchMoveScope c = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-300), true);
        LocalSearchMoveScope d = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1), true);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(stepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        forager.phaseEnded(phaseScope);
    }

    @Test
    public void pickMoveFirstLastStepScoreImproving() {
        AcceptedForager forager = new AcceptedForager((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory(), PickEarlyType.FIRST_LAST_STEP_SCORE_IMPROVING, Integer.MAX_VALUE);
        LocalSearchSolverPhaseScope phaseScope = this.createPhaseScope();
        forager.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = this.createStepScope(phaseScope);
        forager.stepStarted(stepScope);
        LocalSearchMoveScope a = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1), false);
        LocalSearchMoveScope b = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-300), true);
        LocalSearchMoveScope c = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-4000), true);
        LocalSearchMoveScope d = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-20), true);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(stepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        forager.phaseEnded(phaseScope);
    }

    @Test
    public void pickMoveAcceptedRandomly() {
        AcceptedForager forager = new AcceptedForager((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory(), PickEarlyType.NEVER, 3);
        LocalSearchSolverPhaseScope phaseScope = this.createPhaseScope();
        forager.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = this.createStepScope(phaseScope);
        forager.stepStarted(stepScope);
        LocalSearchMoveScope a = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-20), false);
        LocalSearchMoveScope b = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1), true);
        LocalSearchMoveScope c = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-1), true);
        LocalSearchMoveScope d = this.createMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-20), true);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(stepScope);
        Assert.assertSame((Object)b, (Object)pickedScope);
        forager.phaseEnded(phaseScope);
    }

    private LocalSearchSolverPhaseScope createPhaseScope() {
        DefaultSolverScope solverScope = new DefaultSolverScope();
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        DroolsScoreDirectorFactory scoreDirectorFactory = new DroolsScoreDirectorFactory();
        scoreDirectorFactory.setSolutionDescriptor(TestdataSolution.buildSolutionDescriptor());
        scoreDirectorFactory.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        solverScope.setScoreDirector((InnerScoreDirector)scoreDirectorFactory.buildScoreDirector());
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(2)).thenReturn((Object)0);
        solverScope.setWorkingRandom(workingRandom);
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-10));
        LocalSearchStepScope lastLocalSearchStepScope = new LocalSearchStepScope(phaseScope);
        lastLocalSearchStepScope.setScore((Score)SimpleScore.valueOf((int)-100));
        phaseScope.setLastCompletedStepScope(lastLocalSearchStepScope);
        return phaseScope;
    }

    private LocalSearchStepScope createStepScope(LocalSearchSolverPhaseScope phaseScope) {
        LocalSearchStepScope stepScope = new LocalSearchStepScope(phaseScope);
        return stepScope;
    }

    public LocalSearchMoveScope createMoveScope(LocalSearchStepScope stepScope, Score score, boolean accepted) {
        LocalSearchMoveScope moveScope = new LocalSearchMoveScope(stepScope);
        moveScope.setMove((Move)new DummyMove());
        moveScope.setScore(score);
        moveScope.setAccepted(Boolean.valueOf(accepted));
        return moveScope;
    }
}

