/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.BestScoreFeasibleTermination;

public class BestScoreFeasibleTerminationTest {
    @Test
    public void solveTermination() {
        BestScoreFeasibleTermination termination = new BestScoreFeasibleTermination();
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDefinition()).thenReturn((Object)new HardSoftScoreDefinition());
        Mockito.when((Object)solverScope.getStartingInitializedScore()).thenReturn((Object)HardSoftScore.valueOf((int)-100, (int)-100));
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-100, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-80, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.2, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-60, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.4, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-40, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.6, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-20, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.8, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)0, (int)-100));
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
    }

    @Test
    public void phaseTermination() {
        BestScoreFeasibleTermination termination = new BestScoreFeasibleTermination();
        AbstractSolverPhaseScope phaseScope = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScope.getScoreDefinition()).thenReturn((Object)new HardSoftScoreDefinition());
        Mockito.when((Object)phaseScope.getStartingScore()).thenReturn((Object)HardSoftScore.valueOf((int)-100, (int)-100));
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-100, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-80, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.2, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-60, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.4, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-40, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.6, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-20, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.8, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)0, (int)-100));
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
    }
}

