/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.BestScoreTermination;

public class BestScoreTerminationTest {
    @Test
    public void solveTermination() {
        BestScoreTermination termination = new BestScoreTermination((Score)SimpleScore.valueOf((int)-1000));
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDefinition()).thenReturn((Object)new SimpleScoreDefinition());
        Mockito.when((Object)solverScope.isBestSolutionInitialized()).thenReturn((Object)true);
        Mockito.when((Object)solverScope.getStartingInitializedScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1040));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.6, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1040));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.6, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1000));
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-900));
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
    }

    @Test
    public void phaseTermination() {
        BestScoreTermination termination = new BestScoreTermination((Score)SimpleScore.valueOf((int)-1000));
        AbstractSolverPhaseScope phaseScope = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScope.getScoreDefinition()).thenReturn((Object)new SimpleScoreDefinition());
        Mockito.when((Object)phaseScope.isBestSolutionInitialized()).thenReturn((Object)true);
        Mockito.when((Object)phaseScope.getStartingScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1040));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.6, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1040));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.6, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1000));
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-900));
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
    }
}

