/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.placer;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.impl.constructionheuristic.placer.AbstractEntityPlacer;
import org.optaplanner.core.impl.constructionheuristic.placer.EntityPlacer;
import org.optaplanner.core.impl.constructionheuristic.placer.Placement;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;

public class QueuedEntityPlacer
extends AbstractEntityPlacer
implements EntityPlacer {
    protected final EntitySelector entitySelector;
    protected final List<MoveSelector> moveSelectorList;

    public QueuedEntityPlacer(EntitySelector entitySelector, List<MoveSelector> moveSelectorList) {
        this.entitySelector = entitySelector;
        this.moveSelectorList = moveSelectorList;
        this.solverPhaseLifecycleSupport.addEventListener(entitySelector);
        for (MoveSelector moveSelector : moveSelectorList) {
            this.solverPhaseLifecycleSupport.addEventListener(moveSelector);
        }
    }

    @Override
    public Iterator<Placement> iterator() {
        return new QueuedEntityPlacingIterator(this.entitySelector.iterator());
    }

    private class QueuedEntityPlacingIterator
    extends UpcomingSelectionIterator<Placement> {
        private final Iterator<Object> entityIterator;
        private Iterator<MoveSelector> moveSelectorIterator;

        private QueuedEntityPlacingIterator(Iterator<Object> entityIterator) {
            this.entityIterator = entityIterator;
            this.moveSelectorIterator = Iterators.emptyIterator();
        }

        @Override
        protected Placement createUpcomingSelection() {
            Iterator moveIterator = null;
            while (moveIterator == null || !moveIterator.hasNext()) {
                while (!this.moveSelectorIterator.hasNext()) {
                    if (!this.entityIterator.hasNext()) {
                        return (Placement)this.noUpcomingSelection();
                    }
                    this.entityIterator.next();
                    this.moveSelectorIterator = QueuedEntityPlacer.this.moveSelectorList.iterator();
                }
                MoveSelector moveSelector = this.moveSelectorIterator.next();
                moveIterator = moveSelector.iterator();
            }
            return new Placement(moveIterator);
        }
    }
}

