/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.entity.descriptor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.solution.Solution;

public class EntityDescriptor {
    private final SolutionDescriptor solutionDescriptor;
    private final Class<?> entityClass;
    private final BeanInfo entityBeanInfo;
    private SelectionFilter movableEntitySelectionFilter;
    private SelectionSorter decreasingDifficultySorter;
    private Map<String, GenuineVariableDescriptor> genuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor> shadowVariableDescriptorMap;

    public EntityDescriptor(SolutionDescriptor solutionDescriptor, Class<?> entityClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.entityClass = entityClass;
        try {
            this.entityBeanInfo = Introspector.getBeanInfo(entityClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The planningEntityClass (" + entityClass + ") is not a valid java bean.", e);
        }
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processEntityAnnotations(descriptorPolicy);
        this.processMethodAnnotations(descriptorPolicy);
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processEntityAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningEntity entityAnnotation = this.entityClass.getAnnotation(PlanningEntity.class);
        if (entityAnnotation == null) {
            throw new IllegalStateException("The planningEntityClass (" + this.entityClass + ") has been specified as a planning entity in the configuration," + " but does not have a " + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        this.processMovable(descriptorPolicy, entityAnnotation);
        this.processDifficulty(descriptorPolicy, entityAnnotation);
    }

    private void processMovable(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionFilter> movableEntitySelectionFilterClass = entityAnnotation.movableEntitySelectionFilter();
        if (movableEntitySelectionFilterClass == PlanningEntity.NullMovableEntitySelectionFilter.class) {
            movableEntitySelectionFilterClass = null;
        }
        if (movableEntitySelectionFilterClass != null) {
            this.movableEntitySelectionFilter = ConfigUtils.newInstance(this, "movableEntitySelectionFilterClass", movableEntitySelectionFilterClass);
        }
    }

    private void processDifficulty(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionSorterWeightFactory> difficultyWeightFactoryClass;
        Class<? extends Comparator> difficultyComparatorClass = entityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass == PlanningEntity.NullDifficultyComparator.class) {
            difficultyComparatorClass = null;
        }
        if ((difficultyWeightFactoryClass = entityAnnotation.difficultyWeightFactoryClass()) == PlanningEntity.NullDifficultyWeightFactory.class) {
            difficultyWeightFactoryClass = null;
        }
        if (difficultyComparatorClass != null && difficultyWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.entityClass + ") cannot have a difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") and a difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") at the same time.");
        }
        if (difficultyComparatorClass != null) {
            Comparator difficultyComparator = ConfigUtils.newInstance(this, "difficultyComparatorClass", difficultyComparatorClass);
            this.decreasingDifficultySorter = new ComparatorSelectionSorter(difficultyComparator, SelectionSorterOrder.DESCENDING);
        }
        if (difficultyWeightFactoryClass != null) {
            SelectionSorterWeightFactory difficultyWeightFactory = ConfigUtils.newInstance(this, "difficultyWeightFactoryClass", difficultyWeightFactoryClass);
            this.decreasingDifficultySorter = new WeightFactorySelectionSorter(difficultyWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    private void processMethodAnnotations(DescriptorPolicy descriptorPolicy) {
        for (Method method : this.entityClass.getMethods()) {
            if (!method.isAnnotationPresent(ValueRangeProvider.class)) continue;
            descriptorPolicy.addFromEntityValueRangeProvider(method);
        }
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PropertyDescriptor[] propertyDescriptors = this.entityBeanInfo.getPropertyDescriptors();
        this.genuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor>(propertyDescriptors.length);
        this.shadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor>(propertyDescriptors.length);
        boolean noPlanningVariableAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Object variableDescriptor;
            Method propertyGetter = propertyDescriptor.getReadMethod();
            if (propertyGetter == null || !propertyGetter.isAnnotationPresent(PlanningVariable.class)) continue;
            PlanningVariable planningVariableAnnotation = propertyGetter.getAnnotation(PlanningVariable.class);
            noPlanningVariableAnnotation = false;
            if (propertyDescriptor.getWriteMethod() == null) {
                throw new IllegalStateException("The planningEntityClass (" + this.entityClass + ") has a PlanningVariable annotated property (" + propertyDescriptor.getName() + ") that should have a setter.");
            }
            if (planningVariableAnnotation.mappedBy().equals("")) {
                variableDescriptor = new GenuineVariableDescriptor(this, propertyDescriptor);
                this.genuineVariableDescriptorMap.put(propertyDescriptor.getName(), (GenuineVariableDescriptor)variableDescriptor);
                ((GenuineVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
                continue;
            }
            variableDescriptor = new ShadowVariableDescriptor(this, propertyDescriptor);
            this.shadowVariableDescriptorMap.put(propertyDescriptor.getName(), (ShadowVariableDescriptor)variableDescriptor);
            ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
        }
        if (noPlanningVariableAnnotation) {
            throw new IllegalStateException("The planningEntityClass (" + this.entityClass + ") should have at least 1 getter with a " + PlanningVariable.class.getSimpleName() + " annotation.");
        }
    }

    public void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
        for (GenuineVariableDescriptor variableDescriptor : this.genuineVariableDescriptorMap.values()) {
            variableDescriptor.afterAnnotationsProcessed(descriptorPolicy);
        }
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.shadowVariableDescriptorMap.values()) {
            shadowVariableDescriptor.afterAnnotationsProcessed(descriptorPolicy);
        }
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean matchesEntity(Object entity) {
        return this.entityClass.isAssignableFrom(entity.getClass());
    }

    public boolean hasMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter != null;
    }

    public SelectionFilter getMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter;
    }

    public SelectionSorter getDecreasingDifficultySorter() {
        return this.decreasingDifficultySorter;
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        for (PropertyDescriptor propertyDescriptor : this.entityBeanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public Collection<String> getPlanningVariableNameSet() {
        return this.genuineVariableDescriptorMap.keySet();
    }

    public Collection<GenuineVariableDescriptor> getVariableDescriptors() {
        return this.genuineVariableDescriptorMap.values();
    }

    public boolean hasVariableDescriptor(String propertyName) {
        return this.genuineVariableDescriptorMap.containsKey(propertyName);
    }

    public GenuineVariableDescriptor getVariableDescriptor(String propertyName) {
        return this.genuineVariableDescriptorMap.get(propertyName);
    }

    public boolean hasGenuineVariableDescriptor() {
        return !this.genuineVariableDescriptorMap.isEmpty();
    }

    public boolean hasShadowVariableDescriptor(String propertyName) {
        return this.shadowVariableDescriptorMap.containsKey(propertyName);
    }

    public ShadowVariableDescriptor getShadowVariableDescriptor(String propertyName) {
        return this.shadowVariableDescriptorMap.get(propertyName);
    }

    public void addVariableListenersToMap(Map<GenuineVariableDescriptor, List<VariableListener>> variableListenerMap) {
        for (GenuineVariableDescriptor variableDescriptor : this.genuineVariableDescriptorMap.values()) {
            variableListenerMap.put(variableDescriptor, variableDescriptor.buildVariableListenerList());
        }
    }

    public List<Object> extractEntities(Solution solution) {
        return this.solutionDescriptor.getEntityListByEntityClass(solution, this.entityClass);
    }

    public long getProblemScale(Solution solution, Object entity) {
        long problemScale = 1L;
        for (GenuineVariableDescriptor variableDescriptor : this.genuineVariableDescriptorMap.values()) {
            problemScale *= variableDescriptor.getValueCount(solution, entity);
        }
        return problemScale;
    }

    public int countUninitializedVariables(Object entity) {
        int uninitializedVariableCount = 0;
        for (GenuineVariableDescriptor variableDescriptor : this.genuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            ++uninitializedVariableCount;
        }
        return uninitializedVariableCount;
    }

    public boolean isInitialized(Object entity) {
        for (GenuineVariableDescriptor variableDescriptor : this.genuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityClass.getName() + ")";
    }
}

