/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.pillar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultPillarSelector
extends AbstractSelector
implements PillarSelector,
SelectionCacheLifecycleListener {
    protected static final SelectionCacheType CACHE_TYPE = SelectionCacheType.STEP;
    protected final EntitySelector entitySelector;
    protected final Collection<GenuineVariableDescriptor> variableDescriptors;
    protected final boolean randomSelection;
    protected List<List<Object>> cachedPillarList = null;

    public DefaultPillarSelector(EntitySelector entitySelector, Collection<GenuineVariableDescriptor> variableDescriptors, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.variableDescriptors = variableDescriptors;
        this.randomSelection = randomSelection;
        Class<?> entityClass = entitySelector.getEntityDescriptor().getEntityClass();
        for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!entityClass.equals(variableDescriptor.getEntityDescriptor().getEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") with a entityClass (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal to the entitySelector's entityClass (" + entityClass + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") cannot have a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        if (entitySelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has an entitySelector (" + entitySelector + ") with neverEnding (" + entitySelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(entitySelector);
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(CACHE_TYPE, this));
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        return this.entitySelector.getEntityDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return CACHE_TYPE;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        long entitySize = this.entitySelector.getSize();
        if (entitySize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The subChainSelector (" + this + ") has an entitySelector (" + this.entitySelector + ") with entitySize (" + entitySize + ") which is higher than Integer.MAX_VALUE.");
        }
        LinkedHashMap valueStateToPillarMap = new LinkedHashMap((int)entitySize);
        for (Object entity : this.entitySelector) {
            ArrayList<Object> valueState = new ArrayList<Object>(this.variableDescriptors.size());
            for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
                Object value = variableDescriptor.getValue(entity);
                valueState.add(value);
            }
            ArrayList pillar = (ArrayList)valueStateToPillarMap.get(valueState);
            if (pillar == null) {
                pillar = new ArrayList();
                valueStateToPillarMap.put(valueState, pillar);
            }
            pillar.add(entity);
        }
        this.cachedPillarList = new ArrayList(valueStateToPillarMap.values());
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedPillarList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.cachedPillarList.size();
    }

    @Override
    public Iterator<List<Object>> iterator() {
        if (!this.randomSelection) {
            return this.cachedPillarList.iterator();
        }
        return new CachedListRandomIterator<List<Object>>(this.cachedPillarList, this.workingRandom);
    }

    @Override
    public ListIterator<List<Object>> listIterator() {
        if (!this.randomSelection) {
            return this.cachedPillarList.listIterator();
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<List<Object>> listIterator(int index) {
        if (!this.randomSelection) {
            return this.cachedPillarList.listIterator(index);
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ")";
    }
}

