/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Collection;
import java.util.Iterator;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractOriginalSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.ListIterable;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedSwapMove;

public class SwapMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector leftEntitySelector;
    protected final EntitySelector rightEntitySelector;
    protected final Collection<GenuineVariableDescriptor> variableDescriptors;
    protected final boolean randomSelection;
    protected final boolean anyChained;

    public SwapMoveSelector(EntitySelector leftEntitySelector, EntitySelector rightEntitySelector, Collection<GenuineVariableDescriptor> variableDescriptors, boolean randomSelection) {
        this.leftEntitySelector = leftEntitySelector;
        this.rightEntitySelector = rightEntitySelector;
        this.variableDescriptors = variableDescriptors;
        this.randomSelection = randomSelection;
        EntityDescriptor leftEntityDescriptor = leftEntitySelector.getEntityDescriptor();
        EntityDescriptor rightEntityDescriptor = rightEntitySelector.getEntityDescriptor();
        if (!leftEntityDescriptor.getEntityClass().equals(rightEntityDescriptor.getEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a leftEntitySelector's entityClass (" + leftEntityDescriptor.getEntityClass() + ") which is not equal to the rightEntitySelector's entityClass (" + rightEntityDescriptor.getEntityClass() + ").");
        }
        boolean anyChained = false;
        if (variableDescriptors.isEmpty()) {
            throw new IllegalStateException("The selector (" + this + ")'s variableDescriptors (" + variableDescriptors + ") is empty.");
        }
        for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!leftEntityDescriptor.getEntityClass().equals(variableDescriptor.getEntityDescriptor().getEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor with a entityClass (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal to the leftEntitySelector's entityClass (" + leftEntityDescriptor.getEntityClass() + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            anyChained = true;
        }
        this.anyChained = anyChained;
        this.solverPhaseLifecycleSupport.addEventListener(leftEntitySelector);
        if (leftEntitySelector != rightEntitySelector) {
            this.solverPhaseLifecycleSupport.addEventListener(rightEntitySelector);
        }
    }

    @Override
    public boolean isCountable() {
        return this.leftEntitySelector.isCountable() && this.rightEntitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftEntitySelector.isNeverEnding() || this.rightEntitySelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return AbstractOriginalSwapIterator.getSize(this.leftEntitySelector, this.rightEntitySelector);
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new AbstractOriginalSwapIterator<Move, Object>((ListIterable)this.leftEntitySelector, (ListIterable)this.rightEntitySelector){

                @Override
                protected Move newSwapSelection(Object leftSubSelection, Object rightSubSelection) {
                    return SwapMoveSelector.this.anyChained ? new ChainedSwapMove(SwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection) : new SwapMove(SwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection);
                }
            };
        }
        return new AbstractRandomSwapIterator<Move, Object>((Iterable)this.leftEntitySelector, (Iterable)this.rightEntitySelector){

            @Override
            protected Move newSwapSelection(Object leftSubSelection, Object rightSubSelection) {
                return SwapMoveSelector.this.anyChained ? new ChainedSwapMove(SwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection) : new SwapMove(SwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftEntitySelector + ", " + this.rightEntitySelector + ")";
    }
}

