/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Iterator;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainReversingChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;

public class SubChainChangeMoveSelector
extends GenericMoveSelector {
    protected final SubChainSelector subChainSelector;
    protected final EntityIndependentValueSelector valueSelector;
    protected final boolean randomSelection;
    protected final boolean selectReversingMoveToo;

    public SubChainChangeMoveSelector(SubChainSelector subChainSelector, EntityIndependentValueSelector valueSelector, boolean randomSelection, boolean selectReversingMoveToo) {
        this.subChainSelector = subChainSelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        this.selectReversingMoveToo = selectReversingMoveToo;
        if (subChainSelector.getVariableDescriptor() != valueSelector.getVariableDescriptor()) {
            throw new IllegalStateException("The selector (" + this + ") has a subChainSelector (" + subChainSelector + ") with variableDescriptor (" + subChainSelector.getVariableDescriptor() + ") which is not the same as the valueSelector (" + valueSelector + ")'s variableDescriptor(" + valueSelector.getVariableDescriptor() + ").");
        }
        if (!randomSelection) {
            if (subChainSelector.isNeverEnding()) {
                throw new IllegalStateException("The selector (" + this + ") has a subChainSelector (" + subChainSelector + ") with neverEnding (" + subChainSelector.isNeverEnding() + ").");
            }
            if (valueSelector.isNeverEnding()) {
                throw new IllegalStateException("The selector (" + this + ") has a valueSelector (" + valueSelector + ") with neverEnding (" + valueSelector.isNeverEnding() + ").");
            }
        }
        this.solverPhaseLifecycleSupport.addEventListener(subChainSelector);
        this.solverPhaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public boolean isCountable() {
        return this.subChainSelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.subChainSelector.getSize() * this.valueSelector.getSize();
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainChangeMoveIterator();
        }
        return new RandomSubChainChangeMoveIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.subChainSelector + ", " + this.valueSelector + ")";
    }

    private class RandomSubChainChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<SubChain> subChainIterator;
        private Iterator<Object> valueIterator;

        private RandomSubChainChangeMoveIterator() {
            this.subChainIterator = SubChainChangeMoveSelector.this.subChainSelector.iterator();
            this.valueIterator = SubChainChangeMoveSelector.this.valueSelector.iterator();
            if (!this.subChainIterator.hasNext() || !this.valueIterator.hasNext()) {
                this.upcomingSelection = this.noUpcomingSelection();
                this.upcomingCreated = true;
            }
        }

        @Override
        protected Move createUpcomingSelection() {
            if (!this.subChainIterator.hasNext()) {
                this.subChainIterator = SubChainChangeMoveSelector.this.subChainSelector.iterator();
            }
            SubChain subChain = this.subChainIterator.next();
            int subChainIteratorCreationCount = 0;
            while (!this.valueIterator.hasNext()) {
                this.valueIterator = SubChainChangeMoveSelector.this.valueSelector.iterator();
                if (this.valueIterator.hasNext()) continue;
                if (!this.subChainIterator.hasNext()) {
                    this.subChainIterator = SubChainChangeMoveSelector.this.subChainSelector.iterator();
                    if (++subChainIteratorCreationCount >= 2) {
                        return (Move)this.noUpcomingSelection();
                    }
                }
                subChain = this.subChainIterator.next();
            }
            Object toValue = this.valueIterator.next();
            boolean reversing = SubChainChangeMoveSelector.this.selectReversingMoveToo ? SubChainChangeMoveSelector.this.workingRandom.nextBoolean() : false;
            return reversing ? new SubChainReversingChangeMove(subChain, SubChainChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue) : new SubChainChangeMove(subChain, SubChainChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }

    private class OriginalSubChainChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<SubChain> subChainIterator;
        private Iterator<Object> valueIterator = null;
        private SubChain upcomingSubChain;
        private Move nextReversingSelection = null;

        private OriginalSubChainChangeMoveIterator() {
            this.subChainIterator = SubChainChangeMoveSelector.this.subChainSelector.iterator();
            this.valueIterator = SubChainChangeMoveSelector.this.valueSelector.iterator();
            if (!this.subChainIterator.hasNext() || !this.valueIterator.hasNext()) {
                this.upcomingSelection = this.noUpcomingSelection();
                this.upcomingCreated = true;
            } else {
                this.upcomingSubChain = this.subChainIterator.next();
            }
        }

        @Override
        protected Move createUpcomingSelection() {
            if (SubChainChangeMoveSelector.this.selectReversingMoveToo && this.nextReversingSelection != null) {
                Move upcomingSelection = this.nextReversingSelection;
                this.nextReversingSelection = null;
                return upcomingSelection;
            }
            while (!this.valueIterator.hasNext()) {
                if (!this.subChainIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                this.upcomingSubChain = this.subChainIterator.next();
                this.valueIterator = SubChainChangeMoveSelector.this.valueSelector.iterator();
            }
            Object toValue = this.valueIterator.next();
            SubChainChangeMove upcomingSelection = new SubChainChangeMove(this.upcomingSubChain, SubChainChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
            if (SubChainChangeMoveSelector.this.selectReversingMoveToo) {
                this.nextReversingSelection = new SubChainReversingChangeMove(this.upcomingSubChain, SubChainChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
            }
            return upcomingSelection;
        }
    }
}

