/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch;

import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.localsearch.LocalSearchSolverPhase;
import org.optaplanner.core.impl.localsearch.decider.LocalSearchDecider;
import org.optaplanner.core.impl.localsearch.event.LocalSearchSolverPhaseLifecycleListener;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchSolverPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultLocalSearchSolverPhase
extends AbstractSolverPhase
implements LocalSearchSolverPhase,
LocalSearchSolverPhaseLifecycleListener {
    protected LocalSearchDecider decider;
    protected boolean assertStepScoreFromScratch = false;
    protected boolean assertExpectedStepScore = false;

    public LocalSearchDecider getDecider() {
        return this.decider;
    }

    public void setDecider(LocalSearchDecider decider) {
        this.decider = decider;
    }

    public void setAssertStepScoreFromScratch(boolean assertStepScoreFromScratch) {
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
    }

    public void setAssertExpectedStepScore(boolean assertExpectedStepScore) {
        this.assertExpectedStepScore = assertExpectedStepScore;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        while (!this.termination.isPhaseTerminated(phaseScope)) {
            LocalSearchStepScope stepScope = new LocalSearchStepScope(phaseScope);
            stepScope.setTimeGradient(this.termination.calculatePhaseTimeGradient(phaseScope));
            this.stepStarted(stepScope);
            this.decider.decideNextStep(stepScope);
            if (stepScope.getStep() == null) {
                if (this.termination.isPhaseTerminated(phaseScope)) {
                    this.logger.trace("    Step index ({}), time spent ({}) terminated without picking a nextStep.", (Object)stepScope.getStepIndex(), (Object)stepScope.getPhaseScope().calculateSolverTimeMillisSpent());
                    break;
                }
                if (stepScope.getSelectedMoveCount() == 0L) {
                    this.logger.warn("    No doable selected move at step index ({}), time spent ({}). Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)stepScope.getPhaseScope().calculateSolverTimeMillisSpent());
                    break;
                }
                throw new IllegalStateException("The step index (" + stepScope.getStepIndex() + ") has accepted/selected move count (" + stepScope.getAcceptedMoveCount() + "/" + stepScope.getSelectedMoveCount() + ") but failed to pick a nextStep (" + stepScope.getStep() + ").");
            }
            this.doStep(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    private void doStep(LocalSearchStepScope stepScope) {
        LocalSearchSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        Move nextStep = stepScope.getStep();
        nextStep.doMove(stepScope.getScoreDirector());
        phaseScope.getWorkingSolution().setScore(stepScope.getScore());
        if (this.assertStepScoreFromScratch) {
            phaseScope.assertWorkingScoreFromScratch(stepScope.getScore(), nextStep);
        }
        if (this.assertExpectedStepScore) {
            phaseScope.assertExpectedWorkingScore(stepScope.getScore(), nextStep);
        }
        this.bestSolutionRecaller.processWorkingSolutionDuringStep(stepScope);
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
        if (!phaseScope.getScoreDirector().isWorkingSolutionInitialized()) {
            throw new IllegalStateException("Local Search phase started with an uninitialized Solution. First initialize the Solution. For example, run a Construction Heuristic phase first.");
        }
    }

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        LocalSearchSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpent = phaseScope.calculateSolverTimeMillisSpent();
            this.logger.debug("    LS step ({}), time spent ({}), score ({}), {} best score ({}), accepted/selected move count ({}/{}), picked move ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpent, stepScope.getScore(), stepScope.getBestScoreImproved() != false ? "new" : "   ", phaseScope.getBestScore(), stepScope.getAcceptedMoveCount(), stepScope.getSelectedMoveCount(), stepScope.getStepString()});
        }
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        this.logger.info("Local Search phase ({}) ended: step total ({}), time spent ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getNextStepIndex(), phaseScope.calculateSolverTimeMillisSpent(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }
}

