/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.optaplanner.core.impl.phase.scope.AbstractSolverPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;

public class TimeMillisSpentTermination
extends AbstractTermination {
    private final long timeMillisSpentLimit;

    public TimeMillisSpentTermination(long timeMillisSpentLimit) {
        this.timeMillisSpentLimit = timeMillisSpentLimit;
        if (timeMillisSpentLimit <= 0L) {
            throw new IllegalArgumentException("The timeMillisSpentLimit (" + timeMillisSpentLimit + ") cannot be negative.");
        }
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        long solverTimeMillisSpent = solverScope.calculateTimeMillisSpent();
        return this.isTerminated(solverTimeMillisSpent);
    }

    @Override
    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        long phaseTimeMillisSpent = phaseScope.calculatePhaseTimeMillisSpent();
        return this.isTerminated(phaseTimeMillisSpent);
    }

    protected boolean isTerminated(long timeMillisSpent) {
        return timeMillisSpent >= this.timeMillisSpentLimit;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        long solverTimeMillisSpent = solverScope.calculateTimeMillisSpent();
        return this.calculateTimeGradient(solverTimeMillisSpent);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        long phaseTimeMillisSpent = phaseScope.calculatePhaseTimeMillisSpent();
        return this.calculateTimeGradient(phaseTimeMillisSpent);
    }

    protected double calculateTimeGradient(long timeMillisSpent) {
        double timeGradient = (double)timeMillisSpent / (double)this.timeMillisSpentLimit;
        return Math.min(timeGradient, 1.0);
    }
}

