/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simpledouble;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScore;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class SimpleDoubleScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        SimpleDoubleScoreHolder scoreHolder = new SimpleDoubleScoreHolder(constraintMatchEnabled);
        scoreHolder.addConstraintMatch(this.createRuleContext("scoreRule1"), -10.0);
        RuleContext ruleContext2 = this.createRuleContext("scoreRule2");
        scoreHolder.addConstraintMatch(ruleContext2, -2.0);
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.createRuleContext("scoreRule3");
        scoreHolder.addConstraintMatch(ruleContext3, -0.3);
        scoreHolder.addConstraintMatch(ruleContext3, -0.03);
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)-10.03), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)3L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

