/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.value;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.AbstractSelectorConfigTest;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.value.FromSolutionPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ShufflingValueSelector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ValueSelectorConfigTest
extends AbstractSelectorConfigTest {
    @Test
    public void phaseOriginal() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingValueSelector.class, valueSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void stepOriginal() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.STEP);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingValueSelector.class, valueSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void justInTimeOriginal() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
    }

    @Test
    public void phaseRandom() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingValueSelector.class, valueSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void stepRandom() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.STEP);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingValueSelector.class, valueSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void justInTimeRandom() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, valueSelector);
    }

    @Test
    public void phaseShuffled() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingValueSelector.class, valueSelector);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, ((ShufflingValueSelector)valueSelector).getChildValueSelector());
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)valueSelector.getCacheType());
    }

    @Test
    public void stepShuffled() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.STEP);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingValueSelector.class, valueSelector);
        PlannerAssert.assertInstanceOf(FromSolutionPropertyValueSelector.class, ((ShufflingValueSelector)valueSelector).getChildValueSelector());
        Assert.assertEquals((Object)SelectionCacheType.STEP, (Object)valueSelector.getCacheType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void justInTimeShuffled() {
        HeuristicConfigPolicy configPolicy = this.buildHeuristicConfigPolicy();
        EntityDescriptor entityDescriptor = configPolicy.getSolutionDescriptor().getEntityDescriptor(TestdataEntity.class);
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
        valueSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        valueSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        ValueSelector valueSelector = valueSelectorConfig.buildValueSelector(configPolicy, entityDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
    }
}

