/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.cloner;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.accessmodifier.TestdataAccessModifierSolution;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedObject;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedSolution;
import org.optaplanner.core.impl.testdata.domain.collection.TestdataEntityCollectionPropertyEntity;
import org.optaplanner.core.impl.testdata.domain.collection.TestdataEntityCollectionPropertySolution;
import org.optaplanner.core.impl.testdata.domain.collection.TestdataSetBasedEntity;
import org.optaplanner.core.impl.testdata.domain.collection.TestdataSetBasedSolution;
import org.optaplanner.core.impl.testdata.domain.deepcloning.TestdataDeepCloningEntity;
import org.optaplanner.core.impl.testdata.domain.deepcloning.TestdataDeepCloningSolution;
import org.optaplanner.core.impl.testdata.domain.extended.TestdataExtendedEntity;
import org.optaplanner.core.impl.testdata.domain.extended.TestdataExtendedSolution;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public abstract class AbstractSolutionClonerTest {
    protected abstract <Sol extends Solution> SolutionCloner<Sol> createSolutionCloner(SolutionDescriptor var1);

    @Test
    public void cloneSolution() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val1);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val3);
        TestdataSolution original = new TestdataSolution("solution");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        original.setValueList(valueList);
        List<TestdataEntity> originalEntityList = Arrays.asList(a, b, c, d);
        original.setEntityList(originalEntityList);
        TestdataSolution clone = (TestdataSolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertCode("solution", clone);
        Assert.assertSame(valueList, clone.getValueList());
        List<TestdataEntity> cloneEntityList = clone.getEntityList();
        Assert.assertNotSame(originalEntityList, cloneEntityList);
        Assert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataEntity cloneA = cloneEntityList.get(0);
        TestdataEntity cloneB = cloneEntityList.get(1);
        TestdataEntity cloneC = cloneEntityList.get(2);
        TestdataEntity cloneD = cloneEntityList.get(3);
        this.assertEntityClone(a, cloneA, "a", "1");
        this.assertEntityClone(b, cloneB, "b", "1");
        this.assertEntityClone(c, cloneC, "c", "3");
        this.assertEntityClone(d, cloneD, "d", "3");
        b.setValue(val2);
        PlannerAssert.assertCode("2", b.getValue());
        PlannerAssert.assertCode("1", cloneB.getValue());
    }

    @Test
    public void cloneAccessModifierSolution() {
        Object staticObject = new Object();
        TestdataAccessModifierSolution.setStaticField(staticObject);
        SolutionDescriptor solutionDescriptor = TestdataAccessModifierSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val1);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val3);
        TestdataAccessModifierSolution original = new TestdataAccessModifierSolution("solution");
        original.setWriteOnlyField("writeHello");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        original.setValueList(valueList);
        List<TestdataEntity> originalEntityList = Arrays.asList(a, b, c, d);
        original.setEntityList(originalEntityList);
        TestdataAccessModifierSolution clone = (TestdataAccessModifierSolution)cloner.cloneSolution((Solution)original);
        Assert.assertSame((Object)"staticFinalFieldValue", (Object)TestdataAccessModifierSolution.getStaticFinalField());
        Assert.assertSame((Object)staticObject, (Object)TestdataAccessModifierSolution.getStaticField());
        Assert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertCode("solution", clone);
        Assert.assertEquals((Object)original.getFinalField(), (Object)clone.getFinalField());
        Assert.assertEquals((Object)"readHello", (Object)clone.getReadOnlyField());
        Assert.assertSame(valueList, clone.getValueList());
        List<TestdataEntity> cloneEntityList = clone.getEntityList();
        Assert.assertNotSame(originalEntityList, cloneEntityList);
        Assert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataEntity cloneA = cloneEntityList.get(0);
        TestdataEntity cloneB = cloneEntityList.get(1);
        TestdataEntity cloneC = cloneEntityList.get(2);
        TestdataEntity cloneD = cloneEntityList.get(3);
        this.assertEntityClone(a, cloneA, "a", "1");
        this.assertEntityClone(b, cloneB, "b", "1");
        this.assertEntityClone(c, cloneC, "c", "3");
        this.assertEntityClone(d, cloneD, "d", "3");
        b.setValue(val2);
        PlannerAssert.assertCode("2", b.getValue());
        PlannerAssert.assertCode("1", cloneB.getValue());
    }

    @Test
    public void cloneExtendedSolution() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataExtendedEntity a = new TestdataExtendedEntity("a", val1, null);
        TestdataExtendedEntity b = new TestdataExtendedEntity("b", val1, "extraObjectOnEntity");
        TestdataExtendedEntity c = new TestdataExtendedEntity("c", val3);
        TestdataExtendedEntity d = new TestdataExtendedEntity("d", val3, c);
        c.setExtraObject(d);
        TestdataExtendedSolution original = new TestdataExtendedSolution("solution", "extraObjectOnSolution");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        original.setValueList(valueList);
        List<TestdataEntity> originalEntityList = Arrays.asList(a, b, c, d);
        original.setEntityList(originalEntityList);
        TestdataExtendedSolution clone = (TestdataExtendedSolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertCode("solution", clone);
        Assert.assertEquals((Object)"extraObjectOnSolution", (Object)clone.getExtraObject());
        Assert.assertSame(valueList, clone.getValueList());
        List<TestdataEntity> cloneEntityList = clone.getEntityList();
        Assert.assertNotSame(originalEntityList, cloneEntityList);
        Assert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataExtendedEntity cloneA = (TestdataExtendedEntity)cloneEntityList.get(0);
        TestdataExtendedEntity cloneB = (TestdataExtendedEntity)cloneEntityList.get(1);
        TestdataExtendedEntity cloneC = (TestdataExtendedEntity)cloneEntityList.get(2);
        TestdataExtendedEntity cloneD = (TestdataExtendedEntity)cloneEntityList.get(3);
        this.assertEntityClone(a, cloneA, "a", "1");
        Assert.assertEquals(null, (Object)cloneA.getExtraObject());
        this.assertEntityClone(b, cloneB, "b", "1");
        Assert.assertEquals((Object)"extraObjectOnEntity", (Object)cloneB.getExtraObject());
        this.assertEntityClone(c, cloneC, "c", "3");
        Assert.assertEquals((Object)cloneD, (Object)cloneC.getExtraObject());
        this.assertEntityClone(d, cloneD, "d", "3");
        Assert.assertEquals((Object)cloneC, (Object)cloneD.getExtraObject());
        b.setValue(val2);
        PlannerAssert.assertCode("2", b.getValue());
        PlannerAssert.assertCode("1", cloneB.getValue());
    }

    private void assertEntityClone(TestdataEntity originalEntity, TestdataEntity cloneEntity, String entityCode, String valueCode) {
        Assert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        PlannerAssert.assertCode(valueCode, cloneEntity.getValue());
    }

    @Test
    public void cloneChainedSolution() {
        SolutionDescriptor solutionDescriptor = TestdataChainedSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedSolution original = new TestdataChainedSolution("solution");
        List<TestdataChainedAnchor> anchorList = Arrays.asList(a0, b0);
        original.setChainedAnchorList(anchorList);
        List<TestdataChainedEntity> originalEntityList = Arrays.asList(a1, a2, a3, b1);
        original.setChainedEntityList(originalEntityList);
        TestdataChainedSolution clone = (TestdataChainedSolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertCode("solution", clone);
        Assert.assertSame(anchorList, clone.getChainedAnchorList());
        List<TestdataChainedEntity> cloneEntityList = clone.getChainedEntityList();
        Assert.assertNotSame(originalEntityList, cloneEntityList);
        Assert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataChainedEntity cloneA1 = cloneEntityList.get(0);
        TestdataChainedEntity cloneA2 = cloneEntityList.get(1);
        TestdataChainedEntity cloneA3 = cloneEntityList.get(2);
        TestdataChainedEntity cloneB1 = cloneEntityList.get(3);
        this.assertChainedEntityClone(a1, cloneA1, "a1", a0);
        this.assertChainedEntityClone(a2, cloneA2, "a2", cloneA1);
        this.assertChainedEntityClone(a3, cloneA3, "a3", cloneA2);
        this.assertChainedEntityClone(b1, cloneB1, "b1", b0);
        a3.setChainedObject(b1);
        PlannerAssert.assertCode("b1", a3.getChainedObject());
        PlannerAssert.assertCode("a2", cloneA3.getChainedObject());
    }

    private void assertChainedEntityClone(TestdataChainedEntity originalEntity, TestdataChainedEntity cloneEntity, String entityCode, TestdataChainedObject value) {
        Assert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        Assert.assertSame((Object)value, (Object)cloneEntity.getChainedObject());
    }

    @Test
    public void cloneSetBasedSolution() {
        SolutionDescriptor solutionDescriptor = TestdataSetBasedSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataSetBasedEntity a = new TestdataSetBasedEntity("a", val1);
        TestdataSetBasedEntity b = new TestdataSetBasedEntity("b", val1);
        TestdataSetBasedEntity c = new TestdataSetBasedEntity("c", val3);
        TestdataSetBasedEntity d = new TestdataSetBasedEntity("d", val3);
        TestdataSetBasedSolution original = new TestdataSetBasedSolution("solution");
        Comparator<TestdataValue> valueComparator = new Comparator<TestdataValue>(){

            @Override
            public int compare(TestdataValue a, TestdataValue b) {
                return b.getCode().compareTo(a.getCode());
            }
        };
        TreeSet<TestdataValue> valueSet = new TreeSet<TestdataValue>(valueComparator);
        valueSet.addAll(Arrays.asList(val1, val2, val3));
        original.setValueSet(valueSet);
        Comparator<TestdataSetBasedEntity> entityComparator = new Comparator<TestdataSetBasedEntity>(){

            @Override
            public int compare(TestdataSetBasedEntity a, TestdataSetBasedEntity b) {
                return b.getCode().compareTo(a.getCode());
            }
        };
        TreeSet<TestdataSetBasedEntity> originalEntitySet = new TreeSet<TestdataSetBasedEntity>(entityComparator);
        originalEntitySet.addAll(Arrays.asList(a, b, c, d));
        original.setEntitySet(originalEntitySet);
        TestdataSetBasedSolution clone = (TestdataSetBasedSolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        Assert.assertSame(valueSet, clone.getValueSet());
        Set<TestdataSetBasedEntity> cloneEntitySet = clone.getEntitySet();
        Assert.assertNotSame(originalEntitySet, cloneEntitySet);
        Assert.assertTrue((boolean)(cloneEntitySet instanceof SortedSet));
        Assert.assertSame((Object)entityComparator, ((SortedSet)cloneEntitySet).comparator());
        PlannerAssert.assertCode("solution", clone);
        Assert.assertEquals((long)4L, (long)cloneEntitySet.size());
        Iterator<TestdataSetBasedEntity> it = cloneEntitySet.iterator();
        TestdataSetBasedEntity cloneD = it.next();
        TestdataSetBasedEntity cloneC = it.next();
        TestdataSetBasedEntity cloneB = it.next();
        TestdataSetBasedEntity cloneA = it.next();
        this.assertSetBasedEntityClone(a, cloneA, "a", "1");
        this.assertSetBasedEntityClone(b, cloneB, "b", "1");
        this.assertSetBasedEntityClone(c, cloneC, "c", "3");
        this.assertSetBasedEntityClone(d, cloneD, "d", "3");
        b.setValue(val2);
        PlannerAssert.assertCode("2", b.getValue());
        PlannerAssert.assertCode("1", cloneB.getValue());
    }

    private void assertSetBasedEntityClone(TestdataSetBasedEntity originalEntity, TestdataSetBasedEntity cloneEntity, String entityCode, String valueCode) {
        Assert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        PlannerAssert.assertCode(valueCode, cloneEntity.getValue());
    }

    @Test
    public void cloneEntityCollectionPropertySolution() {
        SolutionDescriptor solutionDescriptor = TestdataEntityCollectionPropertySolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataEntityCollectionPropertyEntity a = new TestdataEntityCollectionPropertyEntity("a", val1);
        TestdataEntityCollectionPropertyEntity b = new TestdataEntityCollectionPropertyEntity("b", val1);
        TestdataEntityCollectionPropertyEntity c = new TestdataEntityCollectionPropertyEntity("c", val3);
        a.setEntityList(Arrays.asList(b, c));
        a.setEntitySet(new HashSet<TestdataEntityCollectionPropertyEntity>(Arrays.asList(b, c)));
        a.setEntityMap(new HashMap<String, TestdataEntityCollectionPropertyEntity>());
        a.getEntityMap().put("b", b);
        a.getEntityMap().put("c", c);
        b.setEntityList(Collections.<TestdataEntityCollectionPropertyEntity>emptyList());
        b.setEntitySet(new HashSet<TestdataEntityCollectionPropertyEntity>());
        b.setEntityMap(new HashMap<String, TestdataEntityCollectionPropertyEntity>());
        c.setEntityList(Arrays.asList(a, c));
        c.setEntitySet(new HashSet<TestdataEntityCollectionPropertyEntity>(Arrays.asList(a, c)));
        c.setEntityMap(new HashMap<String, TestdataEntityCollectionPropertyEntity>());
        c.getEntityMap().put("a", a);
        c.getEntityMap().put("c", c);
        TestdataEntityCollectionPropertySolution original = new TestdataEntityCollectionPropertySolution("solution");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        original.setValueList(valueList);
        List<TestdataEntityCollectionPropertyEntity> originalEntityList = Arrays.asList(a, b, c);
        original.setEntityList(originalEntityList);
        TestdataEntityCollectionPropertySolution clone = (TestdataEntityCollectionPropertySolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertCode("solution", clone);
        Assert.assertSame(valueList, clone.getValueList());
        List<TestdataEntityCollectionPropertyEntity> cloneEntityList = clone.getEntityList();
        Assert.assertNotSame(originalEntityList, cloneEntityList);
        Assert.assertEquals((long)3L, (long)cloneEntityList.size());
        TestdataEntityCollectionPropertyEntity cloneA = cloneEntityList.get(0);
        TestdataEntityCollectionPropertyEntity cloneB = cloneEntityList.get(1);
        TestdataEntityCollectionPropertyEntity cloneC = cloneEntityList.get(2);
        this.assertEntityCollectionPropertyEntityClone(a, cloneA, "a", "1");
        Assert.assertEquals((long)2L, (long)cloneA.getEntityList().size());
        Assert.assertSame((Object)cloneB, (Object)cloneA.getEntityList().get(0));
        Assert.assertSame((Object)cloneC, (Object)cloneA.getEntityList().get(1));
        Assert.assertEquals((long)2L, (long)cloneA.getEntitySet().size());
        Assert.assertEquals((long)2L, (long)cloneA.getEntityMap().size());
        Assert.assertSame((Object)cloneB, (Object)cloneA.getEntityMap().get("b"));
        Assert.assertSame((Object)cloneC, (Object)cloneA.getEntityMap().get("c"));
        this.assertEntityCollectionPropertyEntityClone(b, cloneB, "b", "1");
        Assert.assertEquals((long)0L, (long)cloneB.getEntityList().size());
        Assert.assertEquals((long)0L, (long)cloneB.getEntitySet().size());
        Assert.assertEquals((long)0L, (long)cloneB.getEntityMap().size());
        this.assertEntityCollectionPropertyEntityClone(c, cloneC, "c", "3");
        Assert.assertEquals((long)2L, (long)cloneC.getEntityList().size());
        Assert.assertSame((Object)cloneA, (Object)cloneC.getEntityList().get(0));
        Assert.assertSame((Object)cloneC, (Object)cloneC.getEntityList().get(1));
        Assert.assertEquals((long)2L, (long)cloneC.getEntitySet().size());
        Assert.assertEquals((long)2L, (long)cloneC.getEntityMap().size());
        Assert.assertSame((Object)cloneA, (Object)cloneC.getEntityMap().get("a"));
        Assert.assertSame((Object)cloneC, (Object)cloneC.getEntityMap().get("c"));
    }

    private void assertEntityCollectionPropertyEntityClone(TestdataEntityCollectionPropertyEntity originalEntity, TestdataEntityCollectionPropertyEntity cloneEntity, String entityCode, String valueCode) {
        Assert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        PlannerAssert.assertCode(valueCode, cloneEntity.getValue());
    }

    @Test
    public void deepPlanningClone() {
        SolutionDescriptor solutionDescriptor = TestdataDeepCloningSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataDeepCloningEntity a = new TestdataDeepCloningEntity("a", val1);
        List<String> aShadowVariableList = Arrays.asList("shadow a1", "shadow a2");
        a.setShadowVariableList(aShadowVariableList);
        TestdataDeepCloningEntity b = new TestdataDeepCloningEntity("b", val1);
        HashMap<String, String> bShadowVariableMap = new HashMap<String, String>();
        bShadowVariableMap.put("shadow key b1", "shadow value b1");
        bShadowVariableMap.put("shadow key b2", "shadow value b2");
        b.setShadowVariableMap(bShadowVariableMap);
        TestdataDeepCloningEntity c = new TestdataDeepCloningEntity("c", val3);
        List<String> cShadowVariableList = Arrays.asList("shadow c1", "shadow c2");
        c.setShadowVariableList(cShadowVariableList);
        TestdataDeepCloningEntity d = new TestdataDeepCloningEntity("d", val3);
        TestdataDeepCloningSolution original = new TestdataDeepCloningSolution("solution");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        original.setValueList(valueList);
        List<TestdataDeepCloningEntity> originalEntityList = Arrays.asList(a, b, c, d);
        original.setEntityList(originalEntityList);
        TestdataDeepCloningSolution clone = (TestdataDeepCloningSolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertCode("solution", clone);
        Assert.assertSame(valueList, clone.getValueList());
        List<TestdataDeepCloningEntity> cloneEntityList = clone.getEntityList();
        Assert.assertNotSame(originalEntityList, cloneEntityList);
        Assert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataDeepCloningEntity cloneA = cloneEntityList.get(0);
        this.assertDeepCloningEntityClone(a, cloneA, "a", "1");
        TestdataDeepCloningEntity cloneB = cloneEntityList.get(1);
        this.assertDeepCloningEntityClone(b, cloneB, "b", "1");
        TestdataDeepCloningEntity cloneC = cloneEntityList.get(2);
        this.assertDeepCloningEntityClone(c, cloneC, "c", "3");
        TestdataDeepCloningEntity cloneD = cloneEntityList.get(3);
        this.assertDeepCloningEntityClone(d, cloneD, "d", "3");
        b.setValue(val2);
        PlannerAssert.assertCode("2", b.getValue());
        PlannerAssert.assertCode("1", cloneB.getValue());
        b.getShadowVariableMap().put("shadow key b1", "other shadow value b1");
        Assert.assertEquals((Object)"other shadow value b1", (Object)b.getShadowVariableMap().get("shadow key b1"));
        Assert.assertEquals((Object)"shadow value b1", (Object)cloneB.getShadowVariableMap().get("shadow key b1"));
    }

    private void assertDeepCloningEntityClone(TestdataDeepCloningEntity originalEntity, TestdataDeepCloningEntity cloneEntity, String entityCode, String valueCode) {
        Assert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        Assert.assertSame((Object)originalEntity.getValue(), (Object)cloneEntity.getValue());
        List<String> originalShadowVariableList = originalEntity.getShadowVariableList();
        List<String> cloneShadowVariableList = cloneEntity.getShadowVariableList();
        if (originalShadowVariableList == null) {
            PlannerAssert.assertNull(cloneShadowVariableList);
        } else {
            Assert.assertNotSame(originalShadowVariableList, cloneShadowVariableList);
            Assert.assertEquals((long)originalShadowVariableList.size(), (long)cloneShadowVariableList.size());
            for (int i = 0; i < originalShadowVariableList.size(); ++i) {
                Assert.assertEquals((Object)originalShadowVariableList.get(i), (Object)cloneShadowVariableList.get(i));
            }
        }
        Map<String, String> originalShadowVariableMap = originalEntity.getShadowVariableMap();
        Map<String, String> cloneShadowVariableMap = cloneEntity.getShadowVariableMap();
        if (originalShadowVariableMap == null) {
            PlannerAssert.assertNull(cloneShadowVariableMap);
        } else {
            Assert.assertNotSame(originalShadowVariableMap, cloneShadowVariableMap);
            Assert.assertEquals((long)originalShadowVariableMap.size(), (long)cloneShadowVariableMap.size());
            for (String key : originalShadowVariableMap.keySet()) {
                Assert.assertEquals((Object)originalShadowVariableMap.get(key), (Object)cloneShadowVariableMap.get(key));
            }
        }
    }
}

