/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.bigdecimal;

import java.math.BigDecimal;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.valuerange.buildin.bigdecimal.BigDecimalValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class BigDecimalValueRangeTest {
    @Test
    public void getSize() {
        Assert.assertEquals((long)10L, (long)new BigDecimalValueRange(new BigDecimal("0"), new BigDecimal("10")).getSize());
        Assert.assertEquals((long)200L, (long)new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.0")).getSize());
        Assert.assertEquals((long)4007L, (long)new BigDecimalValueRange(new BigDecimal("-15.00"), new BigDecimal("25.07")).getSize());
        Assert.assertEquals((long)0L, (long)new BigDecimalValueRange(new BigDecimal("7.0"), new BigDecimal("7.0")).getSize());
        Assert.assertEquals((long)5L, (long)new BigDecimalValueRange(new BigDecimal("0.0"), new BigDecimal("10.0"), new BigDecimal("2.0")).getSize());
        Assert.assertEquals((long)5L, (long)new BigDecimalValueRange(new BigDecimal("-1.0"), new BigDecimal("9.0"), new BigDecimal("2.0")).getSize());
        Assert.assertEquals((long)4L, (long)new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.4"), new BigDecimal("5.1")).getSize());
    }

    @Test
    public void get() {
        Assert.assertEquals((Object)new BigDecimal("3"), (Object)new BigDecimalValueRange(new BigDecimal("0"), new BigDecimal("10")).get(3L));
        Assert.assertEquals((Object)new BigDecimal("100.3"), (Object)new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.0")).get(3L));
        Assert.assertEquals((Object)new BigDecimal("-4"), (Object)new BigDecimalValueRange(new BigDecimal("-5"), new BigDecimal("25")).get(1L));
        Assert.assertEquals((Object)new BigDecimal("-4.94"), (Object)new BigDecimalValueRange(new BigDecimal("-5.00"), new BigDecimal("25.00")).get(6L));
        Assert.assertEquals((Object)new BigDecimal("6.0"), (Object)new BigDecimalValueRange(new BigDecimal("0.0"), new BigDecimal("10.0"), new BigDecimal("2.0")).get(3L));
        Assert.assertEquals((Object)new BigDecimal("5.0"), (Object)new BigDecimalValueRange(new BigDecimal("-1.0"), new BigDecimal("9.0"), new BigDecimal("2.0")).get(3L));
        Assert.assertEquals((Object)new BigDecimal("115.3"), (Object)new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.4"), new BigDecimal("5.1")).get(3L));
    }

    @Test
    public void contains() {
        Assert.assertEquals((Object)true, (Object)new BigDecimalValueRange(new BigDecimal("0"), new BigDecimal("10")).contains(new BigDecimal("3")));
        Assert.assertEquals((Object)false, (Object)new BigDecimalValueRange(new BigDecimal("0"), new BigDecimal("10")).contains(new BigDecimal("10")));
        Assert.assertEquals((Object)false, (Object)new BigDecimalValueRange(new BigDecimal("0"), new BigDecimal("10")).contains(null));
        Assert.assertEquals((Object)true, (Object)new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.0")).contains(new BigDecimal("100.0")));
        Assert.assertEquals((Object)false, (Object)new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.0")).contains(new BigDecimal("99.9")));
        Assert.assertEquals((Object)true, (Object)new BigDecimalValueRange(new BigDecimal("-5.3"), new BigDecimal("25.2")).contains(new BigDecimal("-5.2")));
        Assert.assertEquals((Object)false, (Object)new BigDecimalValueRange(new BigDecimal("-5.3"), new BigDecimal("25.2")).contains(new BigDecimal("-5.4")));
        Assert.assertEquals((Object)true, (Object)new BigDecimalValueRange(new BigDecimal("0.0"), new BigDecimal("10.0"), new BigDecimal("2.0")).contains(new BigDecimal("2.0")));
        Assert.assertEquals((Object)false, (Object)new BigDecimalValueRange(new BigDecimal("0.0"), new BigDecimal("10.0"), new BigDecimal("2.0")).contains(new BigDecimal("3.0")));
        Assert.assertEquals((Object)true, (Object)new BigDecimalValueRange(new BigDecimal("-1.0"), new BigDecimal("9.0"), new BigDecimal("2.0")).contains(new BigDecimal("1.0")));
        Assert.assertEquals((Object)false, (Object)new BigDecimalValueRange(new BigDecimal("-1.0"), new BigDecimal("9.0"), new BigDecimal("2.0")).contains(new BigDecimal("2.0")));
        Assert.assertEquals((Object)true, (Object)new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.4"), new BigDecimal("5.1")).contains(new BigDecimal("115.3")));
        Assert.assertEquals((Object)false, (Object)new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.4"), new BigDecimal("5.1")).contains(new BigDecimal("115.0")));
    }

    @Test
    public void createOriginalIterator() {
        PlannerAssert.assertAllElementsOfIterator(new BigDecimalValueRange(new BigDecimal("0"), new BigDecimal("4")).createOriginalIterator(), new BigDecimal("0"), new BigDecimal("1"), new BigDecimal("2"), new BigDecimal("3"));
        PlannerAssert.assertElementsOfIterator(new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("104.0")).createOriginalIterator(), new BigDecimal("100.0"), new BigDecimal("100.1"), new BigDecimal("100.2"));
        PlannerAssert.assertElementsOfIterator(new BigDecimalValueRange(new BigDecimal("-4.00"), new BigDecimal("3.00")).createOriginalIterator(), new BigDecimal("-4.00"), new BigDecimal("-3.99"), new BigDecimal("-3.98"));
        PlannerAssert.assertAllElementsOfIterator(new BigDecimalValueRange(new BigDecimal("7"), new BigDecimal("7")).createOriginalIterator(), new BigDecimal[0]);
        PlannerAssert.assertAllElementsOfIterator(new BigDecimalValueRange(new BigDecimal("0.0"), new BigDecimal("10.0"), new BigDecimal("2.0")).createOriginalIterator(), new BigDecimal("0.0"), new BigDecimal("2.0"), new BigDecimal("4.0"), new BigDecimal("6.0"), new BigDecimal("8.0"));
        PlannerAssert.assertAllElementsOfIterator(new BigDecimalValueRange(new BigDecimal("-1.0"), new BigDecimal("9.0"), new BigDecimal("2.0")).createOriginalIterator(), new BigDecimal("-1.0"), new BigDecimal("1.0"), new BigDecimal("3.0"), new BigDecimal("5.0"), new BigDecimal("7.0"));
        PlannerAssert.assertAllElementsOfIterator(new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.4"), new BigDecimal("5.1")).createOriginalIterator(), new BigDecimal("100.0"), new BigDecimal("105.1"), new BigDecimal("110.2"), new BigDecimal("115.3"));
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigDecimalValueRange(new BigDecimal("0"), new BigDecimal("4")).createRandomIterator(workingRandom), new BigDecimal("3"), new BigDecimal("0"));
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("104.0")).createRandomIterator(workingRandom), new BigDecimal("100.3"), new BigDecimal("100.0"));
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigDecimalValueRange(new BigDecimal("-4.00"), new BigDecimal("3.00")).createRandomIterator(workingRandom), new BigDecimal("-3.97"), new BigDecimal("-4.00"));
        PlannerAssert.assertAllElementsOfIterator(new BigDecimalValueRange(new BigDecimal("7"), new BigDecimal("7")).createRandomIterator(workingRandom), new BigDecimal[0]);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigDecimalValueRange(new BigDecimal("0.0"), new BigDecimal("10.0"), new BigDecimal("2.0")).createRandomIterator(workingRandom), new BigDecimal("6.0"), new BigDecimal("0.0"));
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigDecimalValueRange(new BigDecimal("-1.0"), new BigDecimal("9.0"), new BigDecimal("2.0")).createRandomIterator(workingRandom), new BigDecimal("5.0"), new BigDecimal("-1.0"));
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new BigDecimalValueRange(new BigDecimal("100.0"), new BigDecimal("120.4"), new BigDecimal("5.1")).createRandomIterator(workingRandom), new BigDecimal("115.3"), new BigDecimal("100.0"));
    }
}

