/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.primdouble;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.valuerange.buildin.primdouble.DoubleValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class DoubleValueRangeTest {
    @Test
    public void contains() {
        Assert.assertEquals((Object)true, (Object)new DoubleValueRange(0.0, 10.0).contains(Double.valueOf(3.0)));
        Assert.assertEquals((Object)false, (Object)new DoubleValueRange(0.0, 10.0).contains(Double.valueOf(10.0)));
        Assert.assertEquals((Object)false, (Object)new DoubleValueRange(0.0, 10.0).contains(null));
        Assert.assertEquals((Object)true, (Object)new DoubleValueRange(100.0, 120.0).contains(Double.valueOf(100.0)));
        Assert.assertEquals((Object)false, (Object)new DoubleValueRange(100.0, 120.0).contains(Double.valueOf(99.9)));
        Assert.assertEquals((Object)true, (Object)new DoubleValueRange(-5.3, 25.2).contains(Double.valueOf(-5.2)));
        Assert.assertEquals((Object)false, (Object)new DoubleValueRange(-5.3, 25.2).contains(Double.valueOf(-5.4)));
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.3, (Object[])new Double[]{0.0});
        PlannerAssert.assertElementsOfIterator(new DoubleValueRange(0.0, 1.0).createRandomIterator(workingRandom), 0.3, 0.0);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.3, (Object[])new Double[]{0.0});
        PlannerAssert.assertElementsOfIterator(new DoubleValueRange(100.0, 104.0).createRandomIterator(workingRandom), 101.2, 100.0);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.3, (Object[])new Double[]{0.0});
        PlannerAssert.assertElementsOfIterator(new DoubleValueRange(-5.0, 5.0).createRandomIterator(workingRandom), -2.0, -5.0);
        PlannerAssert.assertAllElementsOfIterator(new DoubleValueRange(7.0, 7.0).createRandomIterator(workingRandom), new Double[0]);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)Math.nextAfter(1.0, Double.NEGATIVE_INFINITY));
        PlannerAssert.assertElementsOfIterator(new DoubleValueRange(1.0E-6, 2.0E-6).createRandomIterator(workingRandom), Math.nextAfter(2.0E-6, Double.NEGATIVE_INFINITY));
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)Math.nextAfter(1.0, Double.NEGATIVE_INFINITY));
        PlannerAssert.assertElementsOfIterator(new DoubleValueRange(1000000.0, 2000000.0).createRandomIterator(workingRandom), Math.nextAfter(2000000.0, Double.NEGATIVE_INFINITY));
    }
}

