/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.move;

import java.util.Arrays;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.move.CompositeMove;
import org.optaplanner.core.impl.heuristic.move.DummyMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class CompositeMoveTest {
    @Test
    public void createUndoMove() {
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        DummyMove a = new DummyMove("a");
        DummyMove b = new DummyMove("b");
        DummyMove c = new DummyMove("c");
        CompositeMove move = new CompositeMove(Arrays.asList(a, b, c));
        CompositeMove undoMove = move.createUndoMove(scoreDirector);
        PlannerAssert.assertAllCodesOfIterator(move.getMoveList().iterator(), "a", "b", "c");
        PlannerAssert.assertAllCodesOfIterator(undoMove.getMoveList().iterator(), "undo c", "undo b", "undo a");
    }

    @Test
    public void doMove() {
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        Move a = (Move)Mockito.mock(Move.class);
        Move b = (Move)Mockito.mock(Move.class);
        Move c = (Move)Mockito.mock(Move.class);
        CompositeMove move = new CompositeMove(Arrays.asList(a, b, c));
        move.doMove(scoreDirector);
        ((Move)Mockito.verify((Object)a, (VerificationMode)Mockito.times((int)1))).doMove(scoreDirector);
        ((Move)Mockito.verify((Object)b, (VerificationMode)Mockito.times((int)1))).doMove(scoreDirector);
        ((Move)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).doMove(scoreDirector);
    }
}

