/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import java.util.ArrayList;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class WeightFactorySelectionSorterTest {
    @Test
    public void sortAscending() {
        SelectionSorterWeightFactory<Solution, TestdataEntity> weightFactory = new SelectionSorterWeightFactory<Solution, TestdataEntity>(){

            public Comparable createSorterWeight(Solution solution, TestdataEntity selection) {
                return Integer.valueOf(selection.getCode().charAt(0));
            }
        };
        WeightFactorySelectionSorter selectionSorter = new WeightFactorySelectionSorter((SelectionSorterWeightFactory)weightFactory, SelectionSorterOrder.ASCENDING);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        ArrayList<TestdataEntity> selectionList = new ArrayList<TestdataEntity>();
        selectionList.add(new TestdataEntity("C"));
        selectionList.add(new TestdataEntity("A"));
        selectionList.add(new TestdataEntity("D"));
        selectionList.add(new TestdataEntity("B"));
        selectionSorter.sort(scoreDirector, selectionList);
        PlannerAssert.assertCodesOfIterator(selectionList.iterator(), "A", "B", "C", "D");
    }

    @Test
    public void sortDescending() {
        SelectionSorterWeightFactory<Solution, TestdataEntity> weightFactory = new SelectionSorterWeightFactory<Solution, TestdataEntity>(){

            public Comparable createSorterWeight(Solution solution, TestdataEntity selection) {
                return Integer.valueOf(selection.getCode().charAt(0));
            }
        };
        WeightFactorySelectionSorter selectionSorter = new WeightFactorySelectionSorter((SelectionSorterWeightFactory)weightFactory, SelectionSorterOrder.DESCENDING);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        ArrayList<TestdataEntity> selectionList = new ArrayList<TestdataEntity>();
        selectionList.add(new TestdataEntity("C"));
        selectionList.add(new TestdataEntity("A"));
        selectionList.add(new TestdataEntity("D"));
        selectionList.add(new TestdataEntity("B"));
        selectionSorter.sort(scoreDirector, selectionList);
        PlannerAssert.assertCodesOfIterator(selectionList.iterator(), "D", "C", "B", "A");
    }
}

