/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainSwapMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;

public class SubChainSwapMoveTest {
    @Test
    public void noTrailing() {
        EntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor("chainedObject");
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1, b2, b3});
        SubChainSwapMove move = new SubChainSwapMove(variableDescriptor, new SubChain(Arrays.asList(a3, a4, a5)), new SubChain(Arrays.asList(b2, b3)));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, b2, b3);
        SelectorTestUtils.assertChain(b0, b1, a3, a4, a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a3, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a3, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).beforeVariableChanged((Object)a4, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).afterVariableChanged((Object)a4, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).beforeVariableChanged((Object)a5, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).afterVariableChanged((Object)a5, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).beforeVariableChanged((Object)b2, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).afterVariableChanged((Object)b2, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).beforeVariableChanged((Object)b3, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).afterVariableChanged((Object)b3, "chainedObject");
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
    }

    @Test
    public void oldAndNewTrailing() {
        EntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getVariableDescriptor("chainedObject");
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedEntity b2 = new TestdataChainedEntity("b2", b1);
        TestdataChainedEntity b3 = new TestdataChainedEntity("b3", b2);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1, b2, b3});
        SubChainSwapMove move = new SubChainSwapMove(variableDescriptor, new SubChain(Arrays.asList(a2, a3, a4)), new SubChain(Arrays.asList(b1, b2)));
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, b1, b2, a5);
        SelectorTestUtils.assertChain(b0, a2, a3, a4, b3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)a2, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)a2, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).beforeVariableChanged((Object)a3, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).afterVariableChanged((Object)a3, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).beforeVariableChanged((Object)a4, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).afterVariableChanged((Object)a4, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).beforeVariableChanged((Object)a5, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).afterVariableChanged((Object)a5, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).beforeVariableChanged((Object)b1, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeastOnce())).afterVariableChanged((Object)b1, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).beforeVariableChanged((Object)b2, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.never())).afterVariableChanged((Object)b2, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((Object)b3, "chainedObject");
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((Object)b3, "chainedObject");
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1, b2, b3);
    }
}

