/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.definition.FeasibilityScoreDefinition;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.BestScoreFeasibleTermination;

public class BestScoreFeasibleTerminationTest {
    @Test
    public void solveTermination() {
        FeasibilityScoreDefinition scoreDefinition = (FeasibilityScoreDefinition)Mockito.mock(FeasibilityScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getFeasibleLevelCount()).thenReturn((Object)1);
        BestScoreFeasibleTermination termination = new BestScoreFeasibleTermination(scoreDefinition, new double[0]);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDefinition()).thenReturn((Object)new HardSoftScoreDefinition());
        Mockito.when((Object)solverScope.getStartingInitializedScore()).thenReturn((Object)HardSoftScore.valueOf((int)-100, (int)-100));
        Mockito.when((Object)solverScope.isBestSolutionInitialized()).thenReturn((Object)true);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-100, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-80, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.2, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-60, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.4, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-40, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.6, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-20, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.8, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)0, (int)-100));
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
    }

    @Test
    public void phaseTermination() {
        FeasibilityScoreDefinition scoreDefinition = (FeasibilityScoreDefinition)Mockito.mock(FeasibilityScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getFeasibleLevelCount()).thenReturn((Object)1);
        BestScoreFeasibleTermination termination = new BestScoreFeasibleTermination(scoreDefinition, new double[0]);
        AbstractPhaseScope phaseScope = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScope.getScoreDefinition()).thenReturn((Object)new HardSoftScoreDefinition());
        Mockito.when((Object)phaseScope.getStartingScore()).thenReturn((Object)HardSoftScore.valueOf((int)-100, (int)-100));
        Mockito.when((Object)phaseScope.isBestSolutionInitialized()).thenReturn((Object)true);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-100, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-80, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.2, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-60, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.4, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-40, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.6, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)-20, (int)-100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.8, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)HardSoftScore.valueOf((int)0, (int)-100));
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
    }

    @Test
    public void calculateTimeGradientBendableScoreHHSSS() {
        FeasibilityScoreDefinition scoreDefinition = (FeasibilityScoreDefinition)Mockito.mock(FeasibilityScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getFeasibleLevelCount()).thenReturn((Object)2);
        BestScoreFeasibleTermination termination = new BestScoreFeasibleTermination(scoreDefinition, new double[]{0.75});
        Assert.assertEquals((double)0.6, (double)termination.calculateFeasibilityTimeGradient((FeasibilityScore)BendableScore.valueOf((int[])new int[]{-10, -100}, (int[])new int[]{-50, -60, -70}), (FeasibilityScore)BendableScore.valueOf((int[])new int[]{-4, -40}, (int[])new int[]{-50, -60, -70})), (double)0.0);
    }
}

