/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint.bigdecimal;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.bigdecimal.BigDecimalConstraintMatch;

public class BigDecimalConstraintMatchTotal
extends ConstraintMatchTotal {
    protected final Set<BigDecimalConstraintMatch> constraintMatchSet = new HashSet<BigDecimalConstraintMatch>();
    protected BigDecimal weightTotal = BigDecimal.ZERO;

    public BigDecimalConstraintMatchTotal(String constraintPackage, String constraintName, int scoreLevel) {
        super(constraintPackage, constraintName, scoreLevel);
    }

    public Set<BigDecimalConstraintMatch> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    public BigDecimal getWeightTotal() {
        return this.weightTotal;
    }

    @Override
    public Number getWeightTotalAsNumber() {
        return this.weightTotal;
    }

    public BigDecimalConstraintMatch addConstraintMatch(RuleContext kcontext, BigDecimal weight) {
        this.weightTotal = this.weightTotal.add(weight);
        List<Object> justificationList = this.extractJustificationList(kcontext);
        BigDecimalConstraintMatch constraintMatch = new BigDecimalConstraintMatch(this.constraintPackage, this.constraintName, this.scoreLevel, justificationList, weight);
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        return constraintMatch;
    }

    public void removeConstraintMatch(BigDecimalConstraintMatch constraintMatch) {
        this.weightTotal = this.weightTotal.subtract(constraintMatch.getWeight());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }
}

