/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.value;

import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;

public enum ValueSorterManner {
    INCREASING_STRENGTH,
    INCREASING_STRENGTH_IF_AVAILABLE,
    NONE;


    public boolean hasSorter(GenuineVariableDescriptor variableDescriptor) {
        switch (this) {
            case INCREASING_STRENGTH: {
                return true;
            }
            case INCREASING_STRENGTH_IF_AVAILABLE: {
                return variableDescriptor.getIncreasingStrengthSorter() != null;
            }
            case NONE: {
                return false;
            }
        }
        throw new IllegalStateException("The sorterManner (" + (Object)((Object)this) + ") is not implemented.");
    }

    public SelectionSorter determineSorter(GenuineVariableDescriptor variableDescriptor) {
        switch (this) {
            case INCREASING_STRENGTH: 
            case INCREASING_STRENGTH_IF_AVAILABLE: {
                SelectionSorter sorter = variableDescriptor.getIncreasingStrengthSorter();
                if (sorter == null) {
                    throw new IllegalArgumentException("The sorterManner (" + (Object)((Object)this) + ") on entity class (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ")'s variable (" + variableDescriptor.getVariableName() + ") fails because that variable getter's " + PlanningVariable.class.getSimpleName() + " annotation does not declare any strength comparison.");
                }
                return sorter;
            }
            case NONE: {
                throw new IllegalStateException("Impossible state: hasSorter() should have returned null.");
            }
        }
        throw new IllegalStateException("The sorterManner (" + (Object)((Object)this) + ") is not implemented.");
    }
}

