/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.AbstractEntitySelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class FromSolutionEntitySelector
extends AbstractEntitySelector {
    protected final EntityDescriptor entityDescriptor;
    protected final SelectionCacheType minimumCacheType;
    protected final boolean randomSelection;
    protected List<Object> cachedEntityList = null;
    protected Long cachedEntityListRevision = null;
    protected boolean cachedEntityListIsDirty = false;

    public FromSolutionEntitySelector(EntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        this.entityDescriptor = entityDescriptor;
        this.minimumCacheType = minimumCacheType;
        this.randomSelection = randomSelection;
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public SelectionCacheType getCacheType() {
        SelectionCacheType intrinsicCacheType = SelectionCacheType.STEP;
        return intrinsicCacheType.compareTo(this.minimumCacheType) > 0 ? intrinsicCacheType : this.minimumCacheType;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        this.cachedEntityList = this.entityDescriptor.extractEntities(scoreDirector.getWorkingSolution());
        this.cachedEntityListRevision = scoreDirector.getWorkingEntityListRevision();
        this.cachedEntityListIsDirty = false;
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        super.stepStarted(stepScope);
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        if (scoreDirector.isWorkingEntityListDirty(this.cachedEntityListRevision)) {
            if (this.minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
                this.cachedEntityListIsDirty = true;
            } else {
                this.cachedEntityList = this.entityDescriptor.extractEntities(scoreDirector.getWorkingSolution());
                this.cachedEntityListRevision = scoreDirector.getWorkingEntityListRevision();
            }
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.cachedEntityList = null;
        this.cachedEntityListRevision = null;
        this.cachedEntityListIsDirty = false;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.cachedEntityList.size();
    }

    @Override
    public Iterator<Object> iterator() {
        this.checkCachedEntityListIsDirty();
        if (!this.randomSelection) {
            return this.cachedEntityList.iterator();
        }
        return new CachedListRandomIterator<Object>(this.cachedEntityList, this.workingRandom);
    }

    @Override
    public ListIterator<Object> listIterator() {
        this.checkCachedEntityListIsDirty();
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator();
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        this.checkCachedEntityListIsDirty();
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator(index);
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public Iterator<Object> endingIterator() {
        this.checkCachedEntityListIsDirty();
        return this.cachedEntityList.iterator();
    }

    private void checkCachedEntityListIsDirty() {
        if (this.cachedEntityListIsDirty) {
            throw new IllegalStateException("The selector (" + this + ") with minimumCacheType (" + (Object)((Object)this.minimumCacheType) + ")'s workingEntityList became dirty between steps but is still used afterwards.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityDescriptor.getEntityClass().getSimpleName() + ")";
    }
}

