/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.forager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactory;
import org.optaplanner.core.impl.localsearch.decider.forager.AbstractForager;
import org.optaplanner.core.impl.localsearch.decider.forager.PickEarlyType;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;

public class AcceptedForager
extends AbstractForager {
    protected final DeciderScoreComparatorFactory deciderScoreComparatorFactory;
    protected final PickEarlyType pickEarlyType;
    protected final int acceptedCountLimit;
    protected Comparator<Score> scoreComparator;
    protected long selectedMoveCount;
    protected long acceptedMoveCount;
    protected List<LocalSearchMoveScope> maxScoreAcceptedList;
    protected Score maxAcceptedScore;
    protected List<LocalSearchMoveScope> maxScoreUnacceptedList;
    protected Score maxUnacceptedScore;
    protected LocalSearchMoveScope earlyPickedMoveScope;

    public AcceptedForager(DeciderScoreComparatorFactory deciderScoreComparatorFactory, PickEarlyType pickEarlyType, int acceptedCountLimit) {
        this.deciderScoreComparatorFactory = deciderScoreComparatorFactory;
        this.pickEarlyType = pickEarlyType;
        this.acceptedCountLimit = acceptedCountLimit;
        if (acceptedCountLimit < 1) {
            throw new IllegalArgumentException("The acceptedCountLimit (" + acceptedCountLimit + ") cannot be negative or zero.");
        }
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.deciderScoreComparatorFactory.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.deciderScoreComparatorFactory.stepStarted(stepScope);
        this.scoreComparator = this.deciderScoreComparatorFactory.createDeciderScoreComparator();
        this.selectedMoveCount = 0L;
        this.acceptedMoveCount = 0L;
        this.maxScoreAcceptedList = new ArrayList<LocalSearchMoveScope>(1024);
        this.maxAcceptedScore = null;
        this.maxScoreUnacceptedList = new ArrayList<LocalSearchMoveScope>(1024);
        this.maxUnacceptedScore = null;
        this.earlyPickedMoveScope = null;
    }

    @Override
    public boolean supportsNeverEndingMoveSelector() {
        return this.acceptedCountLimit < Integer.MAX_VALUE;
    }

    @Override
    public void addMove(LocalSearchMoveScope moveScope) {
        ++this.selectedMoveCount;
        if (moveScope.getAccepted().booleanValue()) {
            ++this.acceptedMoveCount;
            this.checkPickEarly(moveScope);
            this.addToMaxScoreAcceptedList(moveScope);
            this.maxScoreUnacceptedList = null;
        } else if (this.acceptedMoveCount == 0L) {
            this.addToMaxScoreUnacceptedList(moveScope);
        }
    }

    protected void checkPickEarly(LocalSearchMoveScope moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_BEST_SCORE_IMPROVING: {
                Score bestScore = moveScope.getStepScope().getPhaseScope().getBestScore();
                if (this.scoreComparator.compare(moveScope.getScore(), bestScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_LAST_STEP_SCORE_IMPROVING: {
                Score lastStepScore = moveScope.getStepScope().getPhaseScope().getLastCompletedStepScope().getScore();
                if (this.scoreComparator.compare(moveScope.getScore(), lastStepScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + (Object)((Object)this.pickEarlyType) + ") is not implemented.");
            }
        }
    }

    protected void addToMaxScoreAcceptedList(LocalSearchMoveScope moveScope) {
        if (this.maxAcceptedScore == null || this.scoreComparator.compare(moveScope.getScore(), this.maxAcceptedScore) > 0) {
            this.maxAcceptedScore = moveScope.getScore();
            this.maxScoreAcceptedList.clear();
            this.maxScoreAcceptedList.add(moveScope);
        } else if (moveScope.getScore().equals(this.maxAcceptedScore)) {
            this.maxScoreAcceptedList.add(moveScope);
        }
    }

    protected void addToMaxScoreUnacceptedList(LocalSearchMoveScope moveScope) {
        if (this.maxUnacceptedScore == null || this.scoreComparator.compare(moveScope.getScore(), this.maxUnacceptedScore) > 0) {
            this.maxUnacceptedScore = moveScope.getScore();
            this.maxScoreUnacceptedList.clear();
            this.maxScoreUnacceptedList.add(moveScope);
        } else if (moveScope.getScore().equals(this.maxUnacceptedScore)) {
            this.maxScoreUnacceptedList.add(moveScope);
        }
    }

    @Override
    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null || this.acceptedMoveCount >= (long)this.acceptedCountLimit;
    }

    @Override
    public LocalSearchMoveScope pickMove(LocalSearchStepScope stepScope) {
        stepScope.setSelectedMoveCount(this.selectedMoveCount);
        stepScope.setAcceptedMoveCount(this.acceptedMoveCount);
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        return this.pickMaxScoreMoveScope(stepScope);
    }

    protected LocalSearchMoveScope pickMaxScoreMoveScope(LocalSearchStepScope stepScope) {
        List<LocalSearchMoveScope> maxScoreList;
        if (this.maxScoreAcceptedList.isEmpty()) {
            if (this.maxScoreUnacceptedList.isEmpty()) {
                return null;
            }
            maxScoreList = this.maxScoreUnacceptedList;
        } else {
            maxScoreList = this.maxScoreAcceptedList;
        }
        if (maxScoreList.size() == 1) {
            return maxScoreList.get(0);
        }
        int randomIndex = stepScope.getWorkingRandom().nextInt(maxScoreList.size());
        return maxScoreList.get(randomIndex);
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.deciderScoreComparatorFactory.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.deciderScoreComparatorFactory.phaseEnded(phaseScope);
        this.scoreComparator = null;
        this.selectedMoveCount = 0L;
        this.acceptedMoveCount = 0L;
        this.maxScoreAcceptedList = null;
        this.maxAcceptedScore = null;
        this.maxScoreUnacceptedList = null;
        this.maxUnacceptedScore = null;
        this.earlyPickedMoveScope = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (Object)((Object)this.pickEarlyType) + ", " + this.acceptedCountLimit + ")";
    }
}

