/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.random;

import java.util.Random;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomAdaptor;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well1024a;
import org.apache.commons.math3.random.Well19937a;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.random.Well44497a;
import org.apache.commons.math3.random.Well44497b;
import org.apache.commons.math3.random.Well512a;
import org.optaplanner.core.config.solver.random.RandomType;
import org.optaplanner.core.impl.solver.random.RandomFactory;

public class DefaultRandomFactory
implements RandomFactory {
    protected final RandomType randomType;
    protected final Long randomSeed;

    public DefaultRandomFactory(RandomType randomType, Long randomSeed) {
        this.randomType = randomType;
        this.randomSeed = randomSeed;
    }

    @Override
    public Random createRandom() {
        switch (this.randomType) {
            case JDK: {
                return this.randomSeed == null ? new Random() : new Random(this.randomSeed);
            }
            case MERSENNE_TWISTER: {
                return new RandomAdaptor((RandomGenerator)(this.randomSeed == null ? new MersenneTwister() : new MersenneTwister(this.randomSeed.longValue())));
            }
            case WELL512A: {
                return new RandomAdaptor((RandomGenerator)(this.randomSeed == null ? new Well512a() : new Well512a(this.randomSeed.longValue())));
            }
            case WELL1024A: {
                return new RandomAdaptor((RandomGenerator)(this.randomSeed == null ? new Well1024a() : new Well1024a(this.randomSeed.longValue())));
            }
            case WELL19937A: {
                return new RandomAdaptor((RandomGenerator)(this.randomSeed == null ? new Well19937a() : new Well19937a(this.randomSeed.longValue())));
            }
            case WELL19937C: {
                return new RandomAdaptor((RandomGenerator)(this.randomSeed == null ? new Well19937c() : new Well19937c(this.randomSeed.longValue())));
            }
            case WELL44497A: {
                return new RandomAdaptor((RandomGenerator)(this.randomSeed == null ? new Well44497a() : new Well44497a(this.randomSeed.longValue())));
            }
            case WELL44497B: {
                return new RandomAdaptor((RandomGenerator)(this.randomSeed == null ? new Well44497b() : new Well44497b(this.randomSeed.longValue())));
            }
        }
        throw new IllegalStateException("The randomType (" + (Object)((Object)this.randomType) + ") is not implemented.");
    }

    public String toString() {
        return this.randomType.name() + (this.randomSeed == null ? "" : " with seed " + this.randomSeed);
    }
}

