/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.AbstractScoreTest;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.impl.score.buildin.bendable.BendableScoreDefinition;
import org.optaplanner.core.impl.testdata.util.SerializationTestUtils;

public class BendableScoreTest
extends AbstractScoreTest {
    private BendableScoreDefinition scoreDefinitionHSS = new BendableScoreDefinition(1, 2);
    private BendableScoreDefinition scoreDefinitionHHSSS = new BendableScoreDefinition(2, 3);

    @Test
    public void parseScore() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{-147, -258, -369}), (Object)this.scoreDefinitionHSS.parseScore("-147/-258/-369"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseScoreIllegalArgument() {
        this.scoreDefinitionHSS.parseScore("-147");
    }

    @Test
    public void feasibleHSS() {
        BendableScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{this.scoreDefinitionHSS.createScore(new int[]{-5, -300, -4000})});
        BendableScoreTest.assertScoreFeasible(new FeasibilityScore[]{this.scoreDefinitionHSS.createScore(new int[]{0, -300, -4000}), this.scoreDefinitionHSS.createScore(new int[]{2, -300, -4000})});
    }

    @Test
    public void addHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{19, -320, 0}), (Object)this.scoreDefinitionHSS.createScore(new int[]{20, -20, -4000}).add(this.scoreDefinitionHSS.createScore(new int[]{-1, -300, 4000})));
    }

    @Test
    public void subtractHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{21, 280, -8000}), (Object)this.scoreDefinitionHSS.createScore(new int[]{20, -20, -4000}).subtract(this.scoreDefinitionHSS.createScore(new int[]{-1, -300, 4000})));
    }

    @Test
    public void multiplyHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{6, -6, 6}), (Object)this.scoreDefinitionHSS.createScore(new int[]{5, -5, 5}).multiply(1.2));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{1, -2, 1}), (Object)this.scoreDefinitionHSS.createScore(new int[]{1, -1, 1}).multiply(1.2));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{4, -5, 4}), (Object)this.scoreDefinitionHSS.createScore(new int[]{4, -4, 4}).multiply(1.2));
    }

    @Test
    public void divideHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{5, -5, 5}), (Object)this.scoreDefinitionHSS.createScore(new int[]{25, -25, 25}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{4, -5, 4}), (Object)this.scoreDefinitionHSS.createScore(new int[]{21, -21, 21}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{4, -5, 4}), (Object)this.scoreDefinitionHSS.createScore(new int[]{24, -24, 24}).divide(5.0));
    }

    @Test
    public void powerHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{9, 16, 25}), (Object)this.scoreDefinitionHSS.createScore(new int[]{3, -4, 5}).power(2.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{3, 4, 5}), (Object)this.scoreDefinitionHSS.createScore(new int[]{9, 16, 25}).power(0.5));
    }

    @Test
    public void negateHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{-3, 4, -5}), (Object)this.scoreDefinitionHSS.createScore(new int[]{3, -4, 5}).negate());
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new int[]{3, -4, 5}), (Object)this.scoreDefinitionHSS.createScore(new int[]{-3, 4, -5}).negate());
    }

    @Test
    public void equalsAndHashCodeHSS() {
        BendableScoreTest.assertScoresEqualsAndHashCode(new Score[]{this.scoreDefinitionHSS.createScore(new int[]{-10, -20, -30}), this.scoreDefinitionHSS.createScore(new int[]{-10, -20, -30})});
    }

    @Test
    public void compareToHSS() {
        BendableScoreTest.assertScoreCompareToOrder(new Score[]{this.scoreDefinitionHSS.createScore(new int[]{-20, Integer.MIN_VALUE, Integer.MIN_VALUE}), this.scoreDefinitionHSS.createScore(new int[]{-20, Integer.MIN_VALUE, -20}), this.scoreDefinitionHSS.createScore(new int[]{-20, Integer.MIN_VALUE, 1}), this.scoreDefinitionHSS.createScore(new int[]{-20, -300, -4000}), this.scoreDefinitionHSS.createScore(new int[]{-20, -300, -300}), this.scoreDefinitionHSS.createScore(new int[]{-20, -300, -20}), this.scoreDefinitionHSS.createScore(new int[]{-20, -300, 300}), this.scoreDefinitionHSS.createScore(new int[]{-20, -20, -300}), this.scoreDefinitionHSS.createScore(new int[]{-20, -20, 0}), this.scoreDefinitionHSS.createScore(new int[]{-20, -20, 1}), this.scoreDefinitionHSS.createScore(new int[]{-1, -300, -4000}), this.scoreDefinitionHSS.createScore(new int[]{-1, -300, -20}), this.scoreDefinitionHSS.createScore(new int[]{-1, -20, -300}), this.scoreDefinitionHSS.createScore(new int[]{1, Integer.MIN_VALUE, -20}), this.scoreDefinitionHSS.createScore(new int[]{1, -20, Integer.MIN_VALUE})});
    }

    @Test
    public void feasibleHHSSS() {
        BendableScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{this.scoreDefinitionHHSSS.createScore(new int[]{-5, 0, -300, -4000, -5000}), this.scoreDefinitionHHSSS.createScore(new int[]{0, -5, -300, -4000, -5000})});
        BendableScoreTest.assertScoreFeasible(new FeasibilityScore[]{this.scoreDefinitionHHSSS.createScore(new int[]{0, 0, -300, -4000, -5000}), this.scoreDefinitionHHSSS.createScore(new int[]{0, 2, -300, -4000, -5000}), this.scoreDefinitionHHSSS.createScore(new int[]{2, 0, -300, -4000, -5000})});
    }

    @Test
    public void addHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{19, -320, 0, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{20, -20, -4000, 0, 0}).add(this.scoreDefinitionHHSSS.createScore(new int[]{-1, -300, 4000, 0, 0})));
    }

    @Test
    public void subtractHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{21, 280, -8000, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{20, -20, -4000, 0, 0}).subtract(this.scoreDefinitionHHSSS.createScore(new int[]{-1, -300, 4000, 0, 0})));
    }

    @Test
    public void multiplyHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{6, -6, 6, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{5, -5, 5, 0, 0}).multiply(1.2));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{1, -2, 1, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{1, -1, 1, 0, 0}).multiply(1.2));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{4, -5, 4, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{4, -4, 4, 0, 0}).multiply(1.2));
    }

    @Test
    public void divideHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{5, -5, 5, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{25, -25, 25, 0, 0}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{4, -5, 4, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{21, -21, 21, 0, 0}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{4, -5, 4, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{24, -24, 24, 0, 0}).divide(5.0));
    }

    @Test
    public void powerHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{9, 16, 25, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{3, -4, 5, 0, 0}).power(2.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{3, 4, 5, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{9, 16, 25, 0, 0}).power(0.5));
    }

    @Test
    public void negateHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{-3, 4, -5, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{3, -4, 5, 0, 0}).negate());
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new int[]{3, -4, 5, 0, 0}), (Object)this.scoreDefinitionHHSSS.createScore(new int[]{-3, 4, -5, 0, 0}).negate());
    }

    @Test
    public void equalsAndHashCodeHHSSS() {
        BendableScoreTest.assertScoresEqualsAndHashCode(new Score[]{this.scoreDefinitionHHSSS.createScore(new int[]{-10, -20, -30, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-10, -20, -30, 0, 0})});
    }

    @Test
    public void compareToHHSSS() {
        BendableScoreTest.assertScoreCompareToOrder(new Score[]{this.scoreDefinitionHHSSS.createScore(new int[]{-20, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, Integer.MIN_VALUE, -20, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, Integer.MIN_VALUE, 1, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, -300, -4000, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, -300, -300, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, -300, -20, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, -300, 300, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, -20, -300, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, -20, 0, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-20, -20, 1, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-1, -300, -4000, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-1, -300, -20, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{-1, -20, -300, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{1, Integer.MIN_VALUE, -20, 0, 0}), this.scoreDefinitionHHSSS.createScore(new int[]{1, -20, Integer.MIN_VALUE, 0, 0})});
    }

    @Test
    public void serializeAndDeserialize() {
        BendableScore input = this.scoreDefinitionHSS.createScore(new int[]{-5, -300, -4000});
        SerializationTestUtils.serializeAndDeserializeWithAll(input, new SerializationTestUtils.OutputAsserter<BendableScore>(){

            @Override
            public void assertOutput(BendableScore output) {
                Assert.assertEquals((long)1L, (long)output.getHardLevelsSize());
                Assert.assertEquals((long)-5L, (long)output.getHardScore(0));
                Assert.assertEquals((long)2L, (long)output.getSoftLevelsSize());
                Assert.assertEquals((long)-300L, (long)output.getSoftScore(0));
                Assert.assertEquals((long)-4000L, (long)output.getSoftScore(1));
            }
        });
    }
}

