/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoft;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.AbstractScoreTest;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.impl.testdata.util.SerializationTestUtils;

public class HardMediumSoftScoreTest
extends AbstractScoreTest {
    @Test
    public void parseScore() {
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)-147, (int)-258, (int)-369), (Object)HardMediumSoftScore.parseScore((String)"-147hard/-258medium/-369soft"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseScoreIllegalArgument() {
        HardMediumSoftScore.parseScore((String)"-147");
    }

    @Test
    public void feasible() {
        HardMediumSoftScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{HardMediumSoftScore.valueOf((int)-5, (int)-300, (int)-4000)});
        HardMediumSoftScoreTest.assertScoreFeasible(new FeasibilityScore[]{HardMediumSoftScore.valueOf((int)0, (int)-300, (int)-4000), HardMediumSoftScore.valueOf((int)2, (int)-300, (int)-4000)});
    }

    @Test
    public void add() {
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)19, (int)-320, (int)0), (Object)HardMediumSoftScore.valueOf((int)20, (int)-20, (int)-4000).add(HardMediumSoftScore.valueOf((int)-1, (int)-300, (int)4000)));
    }

    @Test
    public void subtract() {
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)21, (int)280, (int)-8000), (Object)HardMediumSoftScore.valueOf((int)20, (int)-20, (int)-4000).subtract(HardMediumSoftScore.valueOf((int)-1, (int)-300, (int)4000)));
    }

    @Test
    public void multiply() {
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)6, (int)-6, (int)6), (Object)HardMediumSoftScore.valueOf((int)5, (int)-5, (int)5).multiply(1.2));
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)1, (int)-2, (int)1), (Object)HardMediumSoftScore.valueOf((int)1, (int)-1, (int)1).multiply(1.2));
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)4, (int)-5, (int)4), (Object)HardMediumSoftScore.valueOf((int)4, (int)-4, (int)4).multiply(1.2));
    }

    @Test
    public void divide() {
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)5, (int)-5, (int)5), (Object)HardMediumSoftScore.valueOf((int)25, (int)-25, (int)25).divide(5.0));
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)4, (int)-5, (int)4), (Object)HardMediumSoftScore.valueOf((int)21, (int)-21, (int)21).divide(5.0));
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)4, (int)-5, (int)4), (Object)HardMediumSoftScore.valueOf((int)24, (int)-24, (int)24).divide(5.0));
    }

    @Test
    public void power() {
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)9, (int)16, (int)25), (Object)HardMediumSoftScore.valueOf((int)3, (int)-4, (int)5).power(2.0));
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)3, (int)4, (int)5), (Object)HardMediumSoftScore.valueOf((int)9, (int)16, (int)25).power(0.5));
    }

    @Test
    public void negate() {
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)-3, (int)4, (int)-5), (Object)HardMediumSoftScore.valueOf((int)3, (int)-4, (int)5).negate());
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)3, (int)-4, (int)5), (Object)HardMediumSoftScore.valueOf((int)-3, (int)4, (int)-5).negate());
    }

    @Test
    public void equalsAndHashCode() {
        HardMediumSoftScoreTest.assertScoresEqualsAndHashCode(new Score[]{HardMediumSoftScore.valueOf((int)-10, (int)-20, (int)-30), HardMediumSoftScore.valueOf((int)-10, (int)-20, (int)-30)});
    }

    @Test
    public void compareTo() {
        HardMediumSoftScoreTest.assertScoreCompareToOrder(new Score[]{HardMediumSoftScore.valueOf((int)-20, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE), HardMediumSoftScore.valueOf((int)-20, (int)Integer.MIN_VALUE, (int)-20), HardMediumSoftScore.valueOf((int)-20, (int)Integer.MIN_VALUE, (int)1), HardMediumSoftScore.valueOf((int)-20, (int)-300, (int)-4000), HardMediumSoftScore.valueOf((int)-20, (int)-300, (int)-300), HardMediumSoftScore.valueOf((int)-20, (int)-300, (int)-20), HardMediumSoftScore.valueOf((int)-20, (int)-300, (int)300), HardMediumSoftScore.valueOf((int)-20, (int)-20, (int)-300), HardMediumSoftScore.valueOf((int)-20, (int)-20, (int)0), HardMediumSoftScore.valueOf((int)-20, (int)-20, (int)1), HardMediumSoftScore.valueOf((int)-1, (int)-300, (int)-4000), HardMediumSoftScore.valueOf((int)-1, (int)-300, (int)-20), HardMediumSoftScore.valueOf((int)-1, (int)-20, (int)-300), HardMediumSoftScore.valueOf((int)1, (int)Integer.MIN_VALUE, (int)-20), HardMediumSoftScore.valueOf((int)1, (int)-20, (int)Integer.MIN_VALUE)});
    }

    @Test
    public void serializeAndDeserialize() {
        HardMediumSoftScore input = HardMediumSoftScore.valueOf((int)-12, (int)3400, (int)-56);
        SerializationTestUtils.serializeAndDeserializeWithAll(input, new SerializationTestUtils.OutputAsserter<HardMediumSoftScore>(){

            @Override
            public void assertOutput(HardMediumSoftScore output) {
                Assert.assertEquals((long)-12L, (long)output.getHardScore());
                Assert.assertEquals((long)3400L, (long)output.getMediumScore());
                Assert.assertEquals((long)-56L, (long)output.getSoftScore());
            }
        });
    }
}

