/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftlong;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.AbstractScoreTest;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.impl.testdata.util.SerializationTestUtils;

public class HardMediumSoftLongScoreTest
extends AbstractScoreTest {
    @Test
    public void parseScore() {
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)-147L, (long)-258L, (long)-369L), (Object)HardMediumSoftLongScore.parseScore((String)"-147hard/-258medium/-369soft"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseScoreIllegalArgument() {
        HardMediumSoftLongScore.parseScore((String)"-147");
    }

    @Test
    public void feasible() {
        HardMediumSoftLongScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{HardMediumSoftLongScore.valueOf((long)-5L, (long)-300L, (long)-4000L)});
        HardMediumSoftLongScoreTest.assertScoreFeasible(new FeasibilityScore[]{HardMediumSoftLongScore.valueOf((long)0L, (long)-300L, (long)-4000L), HardMediumSoftLongScore.valueOf((long)2L, (long)-300L, (long)-4000L)});
    }

    @Test
    public void add() {
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)19L, (long)-320L, (long)0L), (Object)HardMediumSoftLongScore.valueOf((long)20L, (long)-20L, (long)-4000L).add(HardMediumSoftLongScore.valueOf((long)-1L, (long)-300L, (long)4000L)));
    }

    @Test
    public void subtract() {
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)21L, (long)280L, (long)-8000L), (Object)HardMediumSoftLongScore.valueOf((long)20L, (long)-20L, (long)-4000L).subtract(HardMediumSoftLongScore.valueOf((long)-1L, (long)-300L, (long)4000L)));
    }

    @Test
    public void multiply() {
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)6L, (long)-6L, (long)6L), (Object)HardMediumSoftLongScore.valueOf((long)5L, (long)-5L, (long)5L).multiply(1.2));
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)1L, (long)-2L, (long)1L), (Object)HardMediumSoftLongScore.valueOf((long)1L, (long)-1L, (long)1L).multiply(1.2));
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)4L, (long)-5L, (long)4L), (Object)HardMediumSoftLongScore.valueOf((long)4L, (long)-4L, (long)4L).multiply(1.2));
    }

    @Test
    public void divide() {
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)5L, (long)-5L, (long)5L), (Object)HardMediumSoftLongScore.valueOf((long)25L, (long)-25L, (long)25L).divide(5.0));
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)4L, (long)-5L, (long)4L), (Object)HardMediumSoftLongScore.valueOf((long)21L, (long)-21L, (long)21L).divide(5.0));
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)4L, (long)-5L, (long)4L), (Object)HardMediumSoftLongScore.valueOf((long)24L, (long)-24L, (long)24L).divide(5.0));
    }

    @Test
    public void power() {
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)9L, (long)16L, (long)25L), (Object)HardMediumSoftLongScore.valueOf((long)3L, (long)-4L, (long)5L).power(2.0));
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)3L, (long)4L, (long)5L), (Object)HardMediumSoftLongScore.valueOf((long)9L, (long)16L, (long)25L).power(0.5));
    }

    @Test
    public void negate() {
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)-3L, (long)4L, (long)-5L), (Object)HardMediumSoftLongScore.valueOf((long)3L, (long)-4L, (long)5L).negate());
        Assert.assertEquals((Object)HardMediumSoftLongScore.valueOf((long)3L, (long)-4L, (long)5L), (Object)HardMediumSoftLongScore.valueOf((long)-3L, (long)4L, (long)-5L).negate());
    }

    @Test
    public void equalsAndHashCode() {
        HardMediumSoftLongScoreTest.assertScoresEqualsAndHashCode(new Score[]{HardMediumSoftLongScore.valueOf((long)-10L, (long)-20L, (long)-30L), HardMediumSoftLongScore.valueOf((long)-10L, (long)-20L, (long)-30L)});
    }

    @Test
    public void compareTo() {
        HardMediumSoftLongScoreTest.assertScoreCompareToOrder(new Score[]{HardMediumSoftLongScore.valueOf((long)-20L, (long)Long.MIN_VALUE, (long)Long.MIN_VALUE), HardMediumSoftLongScore.valueOf((long)-20L, (long)Long.MIN_VALUE, (long)-20L), HardMediumSoftLongScore.valueOf((long)-20L, (long)Long.MIN_VALUE, (long)1L), HardMediumSoftLongScore.valueOf((long)-20L, (long)-300L, (long)-4000L), HardMediumSoftLongScore.valueOf((long)-20L, (long)-300L, (long)-300L), HardMediumSoftLongScore.valueOf((long)-20L, (long)-300L, (long)-20L), HardMediumSoftLongScore.valueOf((long)-20L, (long)-300L, (long)300L), HardMediumSoftLongScore.valueOf((long)-20L, (long)-20L, (long)-300L), HardMediumSoftLongScore.valueOf((long)-20L, (long)-20L, (long)0L), HardMediumSoftLongScore.valueOf((long)-20L, (long)-20L, (long)1L), HardMediumSoftLongScore.valueOf((long)-1L, (long)-300L, (long)-4000L), HardMediumSoftLongScore.valueOf((long)-1L, (long)-300L, (long)-20L), HardMediumSoftLongScore.valueOf((long)-1L, (long)-20L, (long)-300L), HardMediumSoftLongScore.valueOf((long)1L, (long)Long.MIN_VALUE, (long)-20L), HardMediumSoftLongScore.valueOf((long)1L, (long)-20L, (long)Long.MIN_VALUE)});
    }

    @Test
    public void serializeAndDeserialize() {
        HardMediumSoftLongScore input = HardMediumSoftLongScore.valueOf((long)-12L, (long)3400L, (long)-56L);
        SerializationTestUtils.serializeAndDeserializeWithAll(input, new SerializationTestUtils.OutputAsserter<HardMediumSoftLongScore>(){

            @Override
            public void assertOutput(HardMediumSoftLongScore output) {
                Assert.assertEquals((long)-12L, (long)output.getHardScore());
                Assert.assertEquals((long)3400L, (long)output.getMediumScore());
                Assert.assertEquals((long)-56L, (long)output.getSoftScore());
            }
        });
    }
}

