/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.placer.entity;

import java.util.Iterator;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.constructionheuristic.placer.Placement;
import org.optaplanner.core.impl.constructionheuristic.placer.PooledEntityPlacer;
import org.optaplanner.core.impl.heuristic.move.DummyMove;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class PooledEntityPlacerTest {
    @Test
    public void oneMoveSelector() {
        MoveSelector moveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("a1"), new DummyMove("a2"), new DummyMove("b1"));
        PooledEntityPlacer placer = new PooledEntityPlacer(moveSelector);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        placer.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        placer.phaseStarted(phaseScopeA);
        Iterator placementIterator = placer.iterator();
        PlannerAssert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfIterator(((Placement)placementIterator.next()).iterator(), "a1", "a2", "b1");
        placer.stepEnded(stepScopeA1);
        PlannerAssert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfIterator(((Placement)placementIterator.next()).iterator(), "a1", "a2", "b1");
        placer.stepEnded(stepScopeA2);
        PlannerAssert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeA3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA3.getPhaseScope()).thenReturn((Object)phaseScopeA);
        placer.stepStarted(stepScopeA3);
        PlannerAssert.assertAllCodesOfIterator(((Placement)placementIterator.next()).iterator(), "a1", "a2", "b1");
        placer.stepEnded(stepScopeA3);
        placer.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        placer.phaseStarted(phaseScopeB);
        placementIterator = placer.iterator();
        PlannerAssert.assertTrue((boolean)placementIterator.hasNext());
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        placer.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfIterator(((Placement)placementIterator.next()).iterator(), "a1", "a2", "b1");
        placer.stepEnded(stepScopeB1);
        placer.phaseEnded(phaseScopeB);
        placer.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)moveSelector, 1, 2, 4);
    }
}

