/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.collection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ListValueRangeTest {
    @Test
    public void getSize() {
        PlannerAssert.assertEquals((long)4L, (long)new ListValueRange(Arrays.asList(0, 2, 5, 10)).getSize());
        PlannerAssert.assertEquals((long)5L, (long)new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).getSize());
        PlannerAssert.assertEquals((long)3L, (long)new ListValueRange(Arrays.asList(-15, 25, 0)).getSize());
        PlannerAssert.assertEquals((long)3L, (long)new ListValueRange(Arrays.asList("b", "z", "a")).getSize());
        PlannerAssert.assertEquals((long)0L, (long)new ListValueRange(Collections.emptyList()).getSize());
    }

    @Test
    public void get() {
        PlannerAssert.assertEquals((long)5L, (long)((Integer)new ListValueRange(Arrays.asList(0, 2, 5, 10)).get(2L)).intValue());
        PlannerAssert.assertEquals((long)-120L, (long)((Integer)new ListValueRange(Arrays.asList(100, -120)).get(1L)).intValue());
        PlannerAssert.assertEquals((Object)"c", (Object)new ListValueRange(Arrays.asList("b", "z", "a", "c", "g", "d")).get(3L));
    }

    @Test
    public void contains() {
        PlannerAssert.assertEquals((Object)true, (Object)new ListValueRange(Arrays.asList(0, 2, 5, 10)).contains((Object)5));
        PlannerAssert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList(0, 2, 5, 10)).contains((Object)4));
        PlannerAssert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList(0, 2, 5, 10)).contains(null));
        PlannerAssert.assertEquals((Object)true, (Object)new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).contains((Object)7));
        PlannerAssert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).contains((Object)9));
        PlannerAssert.assertEquals((Object)true, (Object)new ListValueRange(Arrays.asList(-15, 25, 0)).contains((Object)-15));
        PlannerAssert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList(-15, 25, 0)).contains((Object)-14));
        PlannerAssert.assertEquals((Object)true, (Object)new ListValueRange(Arrays.asList("b", "z", "a")).contains((Object)"a"));
        PlannerAssert.assertEquals((Object)false, (Object)new ListValueRange(Arrays.asList("b", "z", "a")).contains((Object)"n"));
    }

    @Test
    public void createOriginalIterator() {
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Arrays.asList(0, 2, 5, 10)).createOriginalIterator(), 0, 2, 5, 10);
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).createOriginalIterator(), 100, 120, 5, 7, 8);
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Arrays.asList(-15, 25, 0)).createOriginalIterator(), -15, 25, 0);
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Arrays.asList("b", "z", "a")).createOriginalIterator(), "b", "z", "a");
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Collections.emptyList()).createOriginalIterator(), new String[0]);
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)2, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new ListValueRange(Arrays.asList(0, 2, 5, 10)).createRandomIterator(workingRandom), 5, 0);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)2, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new ListValueRange(Arrays.asList(100, 120, 5, 7, 8)).createRandomIterator(workingRandom), 5, 100);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)2, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new ListValueRange(Arrays.asList(-15, 25, 0)).createRandomIterator(workingRandom), 0, -15);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)2, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new ListValueRange(Arrays.asList("b", "z", "a")).createRandomIterator(workingRandom), "a", "b");
        PlannerAssert.assertAllElementsOfIterator(new ListValueRange(Collections.emptyList()).createRandomIterator(workingRandom), new String[0]);
    }
}

