/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.localsearch.decider.acceptor.tabu.size.ValueRatioTabuSizeStrategy;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class ValueRatioTabuSizeStrategyTest {
    @Test
    public void tabuSize() {
        LocalSearchPhaseScope phaseScope = new LocalSearchPhaseScope((DefaultSolverScope)Mockito.mock(DefaultSolverScope.class));
        Mockito.when((Object)phaseScope.getWorkingValueCount()).thenReturn((Object)100);
        LocalSearchStepScope stepScope = new LocalSearchStepScope(phaseScope);
        Assert.assertEquals((long)10L, (long)new ValueRatioTabuSizeStrategy(0.1).determineTabuSize(stepScope));
        Assert.assertEquals((long)50L, (long)new ValueRatioTabuSizeStrategy(0.5).determineTabuSize(stepScope));
        Assert.assertEquals((long)11L, (long)new ValueRatioTabuSizeStrategy(0.1051).determineTabuSize(stepScope));
        Assert.assertEquals((long)10L, (long)new ValueRatioTabuSizeStrategy(0.1049).determineTabuSize(stepScope));
        Assert.assertEquals((long)1L, (long)new ValueRatioTabuSizeStrategy(1.0E-7).determineTabuSize(stepScope));
        Assert.assertEquals((long)99L, (long)new ValueRatioTabuSizeStrategy(0.9999999).determineTabuSize(stepScope));
    }
}

