/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simpledouble;

import org.optaplanner.core.api.score.AbstractScore;

public final class SimpleDoubleScore
extends AbstractScore<SimpleDoubleScore> {
    private final double score;

    public static SimpleDoubleScore parseScore(String scoreString) {
        return SimpleDoubleScore.valueOf(SimpleDoubleScore.parseLevelAsDouble(SimpleDoubleScore.class, scoreString, scoreString));
    }

    public static SimpleDoubleScore valueOf(double score) {
        return new SimpleDoubleScore(score);
    }

    private SimpleDoubleScore(double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public SimpleDoubleScore add(SimpleDoubleScore augment) {
        return new SimpleDoubleScore(this.score + augment.getScore());
    }

    @Override
    public SimpleDoubleScore subtract(SimpleDoubleScore subtrahend) {
        return new SimpleDoubleScore(this.score - subtrahend.getScore());
    }

    @Override
    public SimpleDoubleScore multiply(double multiplicand) {
        return new SimpleDoubleScore(this.score * multiplicand);
    }

    @Override
    public SimpleDoubleScore divide(double divisor) {
        return new SimpleDoubleScore(this.score / divisor);
    }

    @Override
    public SimpleDoubleScore power(double exponent) {
        return new SimpleDoubleScore(Math.pow(this.score, exponent));
    }

    @Override
    public SimpleDoubleScore negate() {
        return new SimpleDoubleScore(-this.score);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleDoubleScore) {
            SimpleDoubleScore other = (SimpleDoubleScore)o;
            return this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return 629 + Double.valueOf(this.score).hashCode();
    }

    @Override
    public int compareTo(SimpleDoubleScore other) {
        if (this.score < other.getScore()) {
            return -1;
        }
        if (this.score > other.getScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Double.toString(this.score);
    }
}

