/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.composite.CompositeCountableValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public class CompositeValueRangeDescriptor
extends AbstractValueRangeDescriptor
implements EntityIndependentValueRangeDescriptor {
    protected final List<ValueRangeDescriptor> childValueRangeDescriptorList;
    protected boolean entityIndependent;

    public CompositeValueRangeDescriptor(GenuineVariableDescriptor variableDescriptor, boolean addNullInValueRange, List<ValueRangeDescriptor> childValueRangeDescriptorList) {
        super(variableDescriptor, addNullInValueRange);
        this.childValueRangeDescriptorList = childValueRangeDescriptorList;
        this.entityIndependent = true;
        for (ValueRangeDescriptor valueRangeDescriptor : childValueRangeDescriptorList) {
            if (!valueRangeDescriptor.isCountable()) {
                throw new IllegalStateException("The valueRangeDescriptor (" + this + ") has a childValueRangeDescriptor (" + valueRangeDescriptor + ") with countable (" + valueRangeDescriptor.isCountable() + ").");
            }
            if (valueRangeDescriptor.isEntityIndependent()) continue;
            this.entityIndependent = false;
        }
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isEntityIndependent() {
        return this.entityIndependent;
    }

    @Override
    public ValueRange<?> extractValueRange(Solution solution, Object entity) {
        ArrayList<CountableValueRange> childValueRangeList = new ArrayList<CountableValueRange>(this.childValueRangeDescriptorList.size());
        for (ValueRangeDescriptor valueRangeDescriptor : this.childValueRangeDescriptorList) {
            childValueRangeList.add((CountableValueRange)valueRangeDescriptor.extractValueRange(solution, entity));
        }
        return this.doNullInValueRangeWrapping(new CompositeCountableValueRange(childValueRangeList));
    }

    @Override
    public ValueRange<?> extractValueRange(Solution solution) {
        ArrayList<CountableValueRange> childValueRangeList = new ArrayList<CountableValueRange>(this.childValueRangeDescriptorList.size());
        for (ValueRangeDescriptor valueRangeDescriptor : this.childValueRangeDescriptorList) {
            EntityIndependentValueRangeDescriptor entityIndependentValueRangeDescriptor = (EntityIndependentValueRangeDescriptor)valueRangeDescriptor;
            childValueRangeList.add((CountableValueRange)entityIndependentValueRangeDescriptor.extractValueRange(solution));
        }
        return this.doNullInValueRangeWrapping(new CompositeCountableValueRange(childValueRangeList));
    }
}

