/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class VariableListenerSupport {
    private final Map<VariableDescriptor, List<VariableListener>> variableListenerMap;
    private final Map<EntityDescriptor, List<VariableListener>> entityVariableListenerMap;

    public VariableListenerSupport(Map<VariableDescriptor, List<VariableListener>> variableListenerMap) {
        this.variableListenerMap = variableListenerMap;
        this.entityVariableListenerMap = new LinkedHashMap<EntityDescriptor, List<VariableListener>>(variableListenerMap.size());
        for (Map.Entry<VariableDescriptor, List<VariableListener>> entry : variableListenerMap.entrySet()) {
            EntityDescriptor entityDescriptor = entry.getKey().getEntityDescriptor();
            List<VariableListener> variableListenerList = entry.getValue();
            List<VariableListener> entityVariableListenerList = this.entityVariableListenerMap.get(entityDescriptor);
            if (entityVariableListenerList == null) {
                entityVariableListenerList = new ArrayList<VariableListener>(variableListenerList);
                this.entityVariableListenerMap.put(entityDescriptor, entityVariableListenerList);
                continue;
            }
            entityVariableListenerList.addAll(variableListenerList);
        }
    }

    public void beforeEntityAdded(ScoreDirector scoreDirector, EntityDescriptor entityDescriptor, Object entity) {
        for (VariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.beforeEntityAdded(scoreDirector, entity);
        }
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, EntityDescriptor entityDescriptor, Object entity) {
        for (VariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.afterEntityAdded(scoreDirector, entity);
        }
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, VariableDescriptor variableDescriptor, Object entity) {
        if (variableDescriptor.hasAnyShadow()) {
            for (VariableListener variableListener : this.variableListenerMap.get(variableDescriptor)) {
                variableListener.beforeVariableChanged(scoreDirector, entity);
            }
        }
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, VariableDescriptor variableDescriptor, Object entity) {
        if (variableDescriptor.hasAnyShadow()) {
            for (VariableListener variableListener : this.variableListenerMap.get(variableDescriptor)) {
                variableListener.afterVariableChanged(scoreDirector, entity);
            }
        }
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, EntityDescriptor entityDescriptor, Object entity) {
        for (VariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.beforeEntityRemoved(scoreDirector, entity);
        }
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, EntityDescriptor entityDescriptor, Object entity) {
        for (VariableListener variableListener : this.entityVariableListenerMap.get(entityDescriptor)) {
            variableListener.afterEntityRemoved(scoreDirector, entity);
        }
    }
}

