/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch.node.comparator;

import java.util.Comparator;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;

public class DepthFirstNodeComparator
implements Comparator<ExhaustiveSearchNode> {
    private final boolean scoreBounderEnabled;

    public DepthFirstNodeComparator(boolean scoreBounderEnabled) {
        this.scoreBounderEnabled = scoreBounderEnabled;
    }

    @Override
    public int compare(ExhaustiveSearchNode a, ExhaustiveSearchNode b) {
        long bBreadth;
        long bParentBreadth;
        long aParentBreadth;
        int bDepth;
        int aDepth = a.getDepth();
        if (aDepth < (bDepth = b.getDepth())) {
            return -1;
        }
        if (aDepth > bDepth) {
            return 1;
        }
        int scoreComparison = a.getScore().compareTo(b.getScore());
        if (scoreComparison < 0) {
            return -1;
        }
        if (scoreComparison > 0) {
            return 1;
        }
        if (this.scoreBounderEnabled) {
            int optimisticBoundComparison = a.getOptimisticBound().compareTo(b.getOptimisticBound());
            if (optimisticBoundComparison < 0) {
                return -1;
            }
            if (optimisticBoundComparison > 0) {
                return 1;
            }
        }
        if ((aParentBreadth = a.getParentBreadth()) < (bParentBreadth = b.getParentBreadth())) {
            return -1;
        }
        if (aParentBreadth > bParentBreadth) {
            return 1;
        }
        long aBreadth = a.getBreadth();
        if (aBreadth < (bBreadth = b.getBreadth())) {
            return 1;
        }
        if (aBreadth > bBreadth) {
            return -1;
        }
        return 0;
    }
}

