/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.latesimulatedannealing;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.score.ScoreUtils;

public class LateSimulatedAnnealingAcceptor
extends AbstractAcceptor {
    protected int lateSimulatedAnnealingSize = -1;
    protected Score[] previousScores;
    protected int lateScoreIndex = -1;

    public void setLateSimulatedAnnealingSize(int lateSimulatedAnnealingSize) {
        this.lateSimulatedAnnealingSize = lateSimulatedAnnealingSize;
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.validate();
        this.previousScores = new Score[this.lateSimulatedAnnealingSize];
        Score initialScore = phaseScope.getBestScore();
        for (int i = 0; i < this.previousScores.length; ++i) {
            this.previousScores[i] = initialScore;
        }
        this.lateScoreIndex = 0;
    }

    private void validate() {
        if (this.lateSimulatedAnnealingSize <= 0) {
            throw new IllegalArgumentException("The lateSimulatedAnnealingSize (" + this.lateSimulatedAnnealingSize + ") cannot be negative or zero.");
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        Score lastStepScore;
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore = moveScope.getStepScope().getPhaseScope().getLastCompletedStepScope().getScore()) >= 0) {
            return true;
        }
        Score lateScore = this.previousScores[this.lateScoreIndex];
        Score bestScore = moveScope.getStepScope().getPhaseScope().getBestScore();
        Score moveScoreDifference = bestScore.subtract(moveScore);
        double[] moveScoreDifferenceLevels = ScoreUtils.extractLevelDoubles(moveScoreDifference);
        Score lateScoreDifference = bestScore.subtract(lateScore);
        double[] lateScoreDifferenceLevels = ScoreUtils.extractLevelDoubles(lateScoreDifference);
        double acceptChance = 1.0;
        for (int i = 0; i < moveScoreDifferenceLevels.length; ++i) {
            double moveScoreDifferenceLevel = moveScoreDifferenceLevels[i];
            double lateScoreDifferenceLevel = lateScoreDifferenceLevels[i];
            double acceptChanceLevel = moveScoreDifferenceLevel <= 0.0 ? 1.0 : Math.exp(-moveScoreDifferenceLevel / lateScoreDifferenceLevel);
            acceptChance *= acceptChanceLevel;
        }
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.previousScores[this.lateScoreIndex] = stepScope.getScore();
        this.lateScoreIndex = (this.lateScoreIndex + 1) % this.lateSimulatedAnnealingSize;
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.previousScores = null;
        this.lateScoreIndex = -1;
    }
}

